from __future__ import annotations

import json
from pathlib import Path

from ..model import Diagram
from ..model.sheep_wolf_diagram import SHEEP_WOLF_DIAGRAM
from .preprocess import preprocess_diagram
from .mltt import calculate_mltt
from .feedback_loops import calculate_feedback_loops


# Directory constants
OUTPUT_DIR = "../"


def process_design_metrics() -> None:
    diagram = preprocess_diagram(SHEEP_WOLF_DIAGRAM)
    
    mltt_results = calculate_mltt()
    feedback_results = calculate_feedback_loops()
    
    metrics = {
        "mltt": mltt_results,
        "feedback_loops": feedback_results
    }
    
    output_path = Path(__file__).parent / OUTPUT_DIR / "design_metrics.json"
    output_path = output_path.resolve()
    
    with output_path.open("w", encoding="utf-8") as f:
        json.dump(metrics, f, indent=2)
    
    print(f"Design metrics saved to: {output_path}")


if __name__ == "__main__":
    process_design_metrics()

