from __future__ import annotations

from dataclasses import dataclass
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from .diagram_element import DiagramElement


@dataclass
class Link:
    """
    Generic directed link between two diagram elements.
    """

    id: str

    # Directed target of the Link
    target: "DiagramElement"

    # Coarse/fine effect of the link; defaults to 1 when not explicitly specified.
    granularity: float = 1.0


