from __future__ import annotations

from dataclasses import dataclass, field
from typing import List, Optional


# Local type alias for outgoing links; avoids import cycles with `links.py`.
Links = List["Link"]


@dataclass
class DiagramElement:
    """
    Base type for any element that can appear as a node in an IMR diagram.
    """

    id: str
    links: Links = field(default_factory=list)

    # Inferred at runtime
    parent: Optional["DiagramElement"] = None



