"""
IMR diagram data model package.

This package exposes minimal, purely structural data types representing the
elements of an IMR game design diagram: resources and Stocks, Inputs,
Mechanics, and the Links that connect them.
"""

from .attributes import Attribute
from .diagram_element import DiagramElement
from .diagram import Diagram
from .entity import Entity
from .input_model import Input
from .links import Link
from .mechanics import Mechanic

# Stock is an alias for Entity
Stock = Entity

__all__ = [
    "Attribute",
    "Diagram",
    "DiagramElement",
    "Entity",
    "Input",
    "Link",
    "Mechanic",
    "Stock",
]


