from preprocess_telemetry_useful import preprocess_telemetry
from preprocess_telemetry_useful_grouped import group_by_user_singlefile
from preprocess_telemetry_useful_grouped_ordered import order_grouped_events
from preprocess_telemetry_grouped_ordered_filtered import extract_first_complete_session
from preprocess_telemetry_grouped_ordered_filtered_merged import merge_close_actions
from preprocess_telemetry_grouped_ordered_filtered_merged_cleaned import clean_menu_intervals
from metrics_calculate import calculate_metrics
from metrics_summary import compute_grouped_and_overall_summaries


def preprocess_whole():
    print("=== Step 1: Preprocessing telemetry ===")
    preprocess_telemetry()
    
    print("\n=== Step 2: Grouping by user ===")
    group_by_user_singlefile()
    
    print("\n=== Step 3: Ordering grouped events ===")
    order_grouped_events()

    print("\n=== Step 4: Filtering first complete session per user ===")
    extract_first_complete_session()

    print("\n=== Step 5: Merging close actions per category ===")
    merge_close_actions()

    print("\n=== Step 6: Cleaning menu intervals and adding actual_timestamp ===")
    clean_menu_intervals()

    print("\n=== Step 7: Calculating player metrics ===")
    calculate_metrics()

    print("\n=== Step 8: Summarizing player metrics ===")
    compute_grouped_and_overall_summaries()

    print("\n=== All preprocessing steps completed ===")


if __name__ == "__main__":
    preprocess_whole()

