import json
from pathlib import Path

INPUT_FILE = "json_preprocess_usefuldata_grouped.json"
OUTPUT_FILE = "telemetry_useful_grouped_ordered.json"


def order_grouped_events():
    script_dir = Path(__file__).parent
    processed_dir = script_dir / "processed"
    processed_dir.mkdir(exist_ok=True)
    
    input_file = processed_dir / INPUT_FILE
    if not input_file.exists():
        raise FileNotFoundError(f"File non trovato: {input_file}")

    # Output file nella cartella processed
    output_file = processed_dir / OUTPUT_FILE

    # Carica il JSON raggruppato per utente
    with input_file.open("r", encoding="utf-8") as f:
        grouped = json.load(f)

    ordered_grouped = {}

    for user_id, events in grouped.items():
        # Ordiniamo prima per timestamp API/server (`time`), poi per timestamp di Unity (`timestamp_game`)
        def sort_key(ev):
            ts_api = ev.get("time")  # quando l'evento è arrivato lato server
            ts_game = ev.get("timestamp_game")  # tempo interno del client (si resetta ad ogni run)
            # Se uno dei due è None, lo sostituiamo con un valore alto per non rompere l'ordinamento
            if ts_api is None:
                ts_api = float("inf")
            if ts_game is None:
                ts_game = float("inf")
            return (ts_api, ts_game)

        ordered_events = sorted(events, key=sort_key)
        ordered_grouped[user_id] = ordered_events

    # Salva il nuovo file ordinato
    with output_file.open("w", encoding="utf-8") as f:
        json.dump(ordered_grouped, f, indent=2)

    print(f"File ordinato salvato come: {output_file}")
    return output_file


if __name__ == "__main__":
    order_grouped_events()