import json
from pathlib import Path

# ================== CONFIGURAZIONE ==================
INPUT_FILE = "telemetry_useful_grouped_ordered.json"
OUTPUT_FILE = "telemetry_useful__grouped_ordered_filtered.json"
# ====================================================


def extract_first_complete_session():
    script_dir = Path(__file__).parent
    processed_dir = script_dir / "processed"
    processed_dir.mkdir(exist_ok=True)
    
    input_file = processed_dir / INPUT_FILE
    if not input_file.exists():
        raise FileNotFoundError(f"File non trovato: {input_file}")

    output_file = processed_dir / OUTPUT_FILE

    # Carica il JSON raggruppato e ordinato per utente
    with input_file.open("r", encoding="utf-8") as f:
        grouped = json.load(f)

    filtered_grouped = {}

    for user_id, events in grouped.items():
        in_session = False
        session_events = []
        found_complete_session = False

        for ev in events:
            action_name = ev.get("actionName")

            if not in_session:
                # Cerchiamo il primo SESSION_START
                if action_name == "SESSION_START":
                    in_session = True
                    session_events = [ev]
            else:
                # Siamo già dentro una sessione ma arriva un nuovo SESSION_START:
                # scartiamo la sessione parziale precedente e ne iniziamo una nuova.
                if action_name == "SESSION_START":
                    session_events = [ev]
                    continue

                session_events.append(ev)
                # Chiudiamo la sessione al primo SESSION_END successivo
                if action_name == "SESSION_END":
                    filtered_grouped[user_id] = session_events
                    found_complete_session = True
                    break

        # Se non troviamo una sessione completa, semplicemente non aggiungiamo l'utente
        if not found_complete_session:
            continue

    # Salva il nuovo file filtrato
    with output_file.open("w", encoding="utf-8") as f:
        json.dump(filtered_grouped, f, indent=2)

    print(f"File filtrato delle sessioni salvato come: {output_file}")
    return output_file


if __name__ == "__main__":
    extract_first_complete_session()


