import uuid
from typing import Any

from dash import callback, Input, set_props, MATCH, State, Output
from dash_mantine_components import Stack, Group, Radio, RadioGroup

from .chart import Chart


class Pages(Stack):
    def __init__(self, pages: dict[str, Any]):
        pages_id = str(uuid.uuid4())
        group = []
        content = []
        for name, value in pages.items():
            if isinstance(value, Chart):
                if len(value.data) == 0:
                    continue
            group.append(Radio(name, value=f"{pages_id}-{name}"))
            content.append(Stack(value, id=f"{pages_id}-{name}", display="none", h="100%"))
        super().__init__(
            h="100%",
            children=[
                RadioGroup(
                    id={'type': 'pages-radio-group', 'index': pages_id},
                    children=Group(group)
                ),
                Stack(
                    id={'type': 'pages-content', 'index': pages_id},
                    h="100%",
                    children=content
                )
            ]
        )


@callback(
    Output({'type': 'pages-radio-group', 'index': MATCH}, "value"),
    Input({'type': 'pages-radio-group', 'index': MATCH}, "value"),
    State({'type': 'pages-content', 'index': MATCH}, "children"),
)
def show_page(value: str, children: list):
    if value is None:
        return
    for child in children:
        child_id = child["props"]["id"]
        if child_id == value:
            set_props(child_id, {"display": "block"})
        else:
            set_props(child_id, {"display": "none"})
    return value
