function net_load(case_name)
    if isnothing(case_name)
        Dict(
            :name=>nothing,
            :net=>nothing,
            :n_buses=>1,
            :prosumer_buses[1],
            :vm=>[1.],
            :violation=>[0.]
        )
    else
        net = net_parse(JSON.parsefile("cases_json/$case_name.json"))
        net
    end
end

function net_parse(net)
    net = Dict(
        Symbol(key)=>value
        for (key, value) in pairs(net)
    )
    if !isnothing(net[:net])
        for gen in values(net[:net]["gen"])
            gen["cost"] = Float64.(gen["cost"])
        end
    end
    net
end

is_fake_net(net) = isnothing(net[:net])

function net_pf!(net, injection)
    if isnothing(net[:net])
        if rand() > 0.5
            net[:vm] = randn(net[:n_buses]) .+ 1.
        else
            net[:vm] = ones(net[:n_buses])
        end
    elseif !net_pf_real!(net, injection)
        return false
    end
    net[:violation] = [
        if vm > 1.1 vm - 1.1
        elseif vm < 0.9 0.9 - vm
        else 0. end
        for vm in net[:vm]
    ]
    true
end

function net_pf_closest!(net, injection)
    distances = sum((net[:injections] .- injection) .^ 2, dims=1)[1, :]
    (val, i) = findmin(distances)
    vm = net[:vms][i]
    if isnothing(vm) return false
    else
        net[:vm] = net[:vms][i]
        return true
    end
end

function net_pf_k!(net, injection)
    distances = sum((net[:injections] .- injection) .^ 2, dims=1)[1, :]
    closest = partialsortperm(distances, 1:5)
    closest = [val for val in closest if !isnothing(net[:vms][val])]
    if length(closest) <= 2 return false end
    vms = net[:vms][closest]
    vms = reduce(hcat, vms)
    weigths = (1. ./ distances[closest])'
    net[:vm] = sum(vms .* weigths, dims=2) ./ sum(weigths)
    true
end

function net_pf_real!(net, injection)
    for (i, (inj, base)) in enumerate(zip(injection, net[:base_injection]))
        net[:net]["load"][string(i)]["pd"] = -(inj + base)
        net[:net]["load"][string(i)]["qd"] = -(inj + base) * net[:pf_coeff]
    end
    optimizer = optimizer_with_attributes(Ipopt.Optimizer, MathOptInterface.Silent() => true)
    result = solve_ac_pf(net[:net], optimizer)
    if !in(result["termination_status"], (
        MathOptInterface.LOCALLY_SOLVED,
        MathOptInterface.OPTIMAL
    )) return false end
    update_data!(net[:net], result["solution"])
    net[:vm] = [net[:net]["bus"][string(i)]["vm"] for i in 1:net[:n_buses]]
    true
end
