import json
from contextlib import suppress
from pathlib import Path

import numpy as np
import pandas as pd


class Results:
    price_reg_seller: np.ndarray[float]
    power_reg_seller: np.ndarray[float]
    unit_price_reg_seller: np.ndarray[float]
    price_reg_buyer: np.ndarray[float]
    power_reg_buyer: np.ndarray[float]
    unit_price_reg_buyer: np.ndarray[float]
    profit_reg: np.ndarray[float]
    capital_reg: np.ndarray[float]
    price_unreg_seller: np.ndarray[float]
    power_unreg_seller: np.ndarray[float]
    unit_price_unreg_seller: np.ndarray[float]
    price_unreg_buyer: np.ndarray[float]
    power_unreg_buyer: np.ndarray[float]
    unit_price_unreg_buyer: np.ndarray[float]
    profit_unreg: np.ndarray[float]
    capital_unreg: np.ndarray[float]
    capital_diff: np.ndarray[float]
    violation_sum: np.ndarray[float]


class Experiment(Results):
    def __init__(self, path: Path | str, samples: int = 300, w: int = 10):
        self.path = path = Path(path)
        self.name = str(path.stem)

        self.data = pd.read_csv(path / "data.csv")
        self.data.drop(["time"], inplace=True, errors="ignore")
        for col in self.data:
            values = self.data[col]
            values = np.convolve(values, np.ones(w), 'valid') / w
            #idx = np.round(np.linspace(0, len(values) - 1, samples)).astype(int)
            #dt = len(values) / (len(idx) - 1)
            #values = values[idx]
            setattr(self, col, values)

        with suppress(FileNotFoundError):
            self.std = pd.read_csv(path / "std.csv")
            self.std.drop(["time"], inplace=True, errors="ignore")
            for col in self.std:
                setattr(self, f"{col}_std", self.std[col])

    def __getitem__(self, item) -> np.array:
        return self.description[item]

    def __repr__(self):
        return f"<Case {self.name}>"

    def __getattr__(self, item):
        return []

    def get(self, item, default=None):
        return self.description.get(item, default)
