using Pkg
Pkg.activate("srpc")
using srpc
using ProgressMeter
using Statistics
using JSON

net_name = "case14"
std_inj = 0.6
results = JSON.parsefile("pf_results/$(net_name).json")
injections = [dict["injection"] for dict in results]
injections = reduce(hcat, injections)

net = net_load(net_name)

arr_predicted = []
arr_real = []

function run(injection)
    distances = sum((injections .- injection) .^ 2, dims=1)[1, :]
    (val, i) = findmin(distances)
    return results[i]["vm"]
end

@showprogress for _ in 1:1000
    inj = (rand(net[:n_buses]) .- 0.5) .* std_inj ./ 0.5
    inj[net[:main_bus]] = 0.
    inj[net[:prosumer_buses]] .-= mean(inj[net[:prosumer_buses]])

    predicted = run(inj)
    converged = net_pf_real!(net, inj)

    if !isnothing(predicted) && converged
        push!(arr_real, net[:vm])
        push!(arr_predicted, predicted)
    end
end

if true
    open("pfs.json", "w") do f
        JSON.print(f, Dict(
            "real"=>arr_real,
            "predicted"=>arr_predicted,
        ))
    end
end
