// client/src/components/VoiceAssistantOverlay.demo.jsx
// Demo page for bottom-sheet voice overlay

import React, { useState, useEffect } from "react";
import VoiceAssistantOverlay from "./VoiceAssistantOverlay";

export default function VoiceAssistantOverlayDemo() {
  const [open, setOpen] = useState(true);
  const [status, setStatus] = useState("listening");
  const [transcript, setTranscript] = useState([]);

  useEffect(() => {
    const samples = [
      "Hi Dora",
      "CALL CAREGIVER",
      "turn on the living-room lights",
      "I'm OK, thank you",
    ];
    let i = 0;
    const t = setInterval(() => {
      if (i < samples.length) {
        setTranscript((prev) => [...prev, samples[i++]]);
      } else {
        setStatus("thinking");
        clearInterval(t);
        setTimeout(() => setStatus("listening"), 1000);
      }
    }, 1200);
    return () => clearInterval(t);
  }, []);

  return (
    <div style={{ height: "100vh", background: "#0B1220" }}>
      <div
        style={{
          padding: "40px",
          color: "#E5E7EB",
          fontSize: "18px",
          lineHeight: 1.6,
        }}
      >
        <h1 style={{ color: "#F8FAFC", marginBottom: "20px" }}>
          DORA Voice Assistant Demo
        </h1>
        <p>This is the background content. The voice overlay appears as a bottom sheet covering ~2/3 of the screen.</p>
        <p>The top 1/3 of the screen remains visible through a gradient backdrop.</p>
        <button
          onClick={() => setOpen(true)}
          style={{
            marginTop: "20px",
            padding: "12px 16px",
            borderRadius: 12,
            border: "1px solid #475569",
            background: "#1E293B",
            color: "#F8FAFC",
            fontWeight: 600,
            cursor: "pointer",
          }}
        >
          Open Voice Assistant
        </button>
      </div>
      <VoiceAssistantOverlay
        open={open}
        status={status}
        transcript={transcript}
        onClose={() => setOpen(false)}
        onImOk={() => alert("Marked: I'm OK")}
        onCallCaregiver={() => alert("Calling caregiver...")}
      />
    </div>
  );
}
