// android/app/src/main/java/com/example/a333/ui/VoiceOverlayDialogFragment.kt
// Bottom-sheet styled dialog (covers ~2/3 of screen height, top 1/3 remains visible)

package com.example.a333.ui

import android.graphics.drawable.GradientDrawable
import android.os.Bundle
import android.text.TextUtils
import android.util.DisplayMetrics
import android.view.*
import android.view.animation.AlphaAnimation
import android.widget.Button
import android.widget.LinearLayout
import android.widget.TextView
import androidx.core.view.setPadding
import androidx.fragment.app.DialogFragment
import com.example.a333.R

class VoiceOverlayDialogFragment(
    private val onCallCaregiver: (() -> Unit)? = null,
    private val onImOk: (() -> Unit)? = null,
    private val onTurnOnLight: (() -> Unit)? = null,
    private val onHealthReport: (() -> Unit)? = null,
    private val onCallGrandPaLi: (() -> Unit)? = null,
) : DialogFragment() {
    private lateinit var recognizedTextView: TextView
    private lateinit var sheet: LinearLayout

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NORMAL, android.R.style.Theme_DeviceDefault_NoActionBar_TranslucentDecor)
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): android.app.Dialog {
        val dialog = super.onCreateDialog(savedInstanceState)
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE)
        dialog.window?.setBackgroundDrawableResource(android.R.color.transparent)
        dialog.window?.setFlags(
            WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN,
            WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN
        )
        return dialog
    }

    override fun onStart() {
        super.onStart()
        try {
            dialog?.window?.apply {
                // Fullscreen window for backdrop, but sheet only covers 2/3
                setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
                setBackgroundDrawable(null)
                clearFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
            }
        } catch (e: Exception) {
            android.util.Log.e("VoiceOverlayDialog", "Failed to setup window: ${e.message}", e)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?,
    ): View? {
        try {
            android.util.Log.d("VoiceOverlayDialog", "onCreateView called")
            val root = inflater.inflate(R.layout.dialog_voice_overlay, container, false)
            android.util.Log.d("VoiceOverlayDialog", "Layout inflated successfully")
            sheet = root.findViewById<LinearLayout>(R.id.va_sheet)
            recognizedTextView = root.findViewById<TextView>(R.id.va_recognized_text)

            // Full screen background
            sheet.background = GradientDrawable().apply {
                setColor(0xFF0F172A.toInt())
            }

            // Set sheet to full screen
            val metrics = DisplayMetrics()
            requireActivity().windowManager.defaultDisplay.getMetrics(metrics)
            val layoutParams = sheet.layoutParams
            layoutParams.height = ViewGroup.LayoutParams.MATCH_PARENT
            layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT
            sheet.layoutParams = layoutParams

            // Option buttons
            val btnLight = root.findViewById<Button>(R.id.va_option_light)
            val btnHealth = root.findViewById<Button>(R.id.va_option_health)
            val btnCall = root.findViewById<Button>(R.id.va_option_call)
            val cancelBtn = root.findViewById<Button>(R.id.va_cancel)

            btnLight.setOnClickListener {
                android.util.Log.d("VoiceOverlayDialog", "Turn on light clicked")
                onTurnOnLight?.invoke()
                dismissAllowingStateLoss()
            }

            btnHealth.setOnClickListener {
                android.util.Log.d("VoiceOverlayDialog", "Health report clicked")
                onHealthReport?.invoke()
                dismissAllowingStateLoss()
            }

            btnCall.setOnClickListener {
                android.util.Log.d("VoiceOverlayDialog", "Call GrandPa.Li clicked")
                onCallGrandPaLi?.invoke()
                dismissAllowingStateLoss()
            }

            cancelBtn.setOnClickListener { dismissAllowingStateLoss() }
            
            // Set initial recognized text
            recognizedTextView.text = "Generate my health report"

            return root
        } catch (e: Exception) {
            android.util.Log.e("VoiceOverlayDialog", "Failed to create view: ${e.message}", e)
            return null
        }
    }

    /** Update recognized text display */
    fun updateRecognizedText(text: String) {
        try {
            if (::recognizedTextView.isInitialized && view != null) {
                if (text.isBlank()) {
                    recognizedTextView.text = "turn on the light"
                } else {
                    recognizedTextView.text = text
                }
            }
        } catch (e: Exception) {
            android.util.Log.e("VoiceOverlayDialog", "Failed to update recognized text: ${e.message}", e)
        }
    }

    /** Update STT status pill - No longer used in new layout */
    @Deprecated("No longer used in new layout")
    fun setStatus(text: String) {
        // Deprecated - status view removed in new layout
    }

    /** Replace hint text - No longer used in new layout */
    @Deprecated("No longer used in new layout")
    fun setHint(text: String) {
        // Deprecated - hint view removed in new layout
    }

    /** Append a transcript chip - No longer used, use updateRecognizedText instead */
    @Deprecated("Use updateRecognizedText instead")
    fun addTranscriptChip(text: String) {
        // Deprecated - use updateRecognizedText instead
        updateRecognizedText(text)
    }
    
    /** Clear all transcript chips - No longer used in new layout */
    @Deprecated("No longer used in new layout")
    fun clearTranscript() {
        // Deprecated - use updateRecognizedText("") instead
        updateRecognizedText("")
    }
}

