// android/app/src/main/java/com/example/a333/ui/VoiceOverlayController.kt
// Simple controller to show/hide overlay and fuzzy wake word match

package com.example.a333.ui

import androidx.fragment.app.FragmentActivity

class VoiceOverlayController(private val activity: FragmentActivity) {
    private var dialog: VoiceOverlayDialogFragment? = null

    fun show(
        onCall: () -> Unit, 
        onOk: () -> Unit,
        onTurnOnLight: (() -> Unit)? = null,
        onHealthReport: (() -> Unit)? = null,
        onCallGrandPaLi: (() -> Unit)? = null
    ) {
        try {
            android.util.Log.d("VoiceOverlayController", "show() called, activity=${activity}, isFinishing=${activity.isFinishing}, isDestroyed=${activity.isDestroyed}")
            
            if (dialog?.isAdded == true || dialog?.dialog?.isShowing == true) {
                android.util.Log.d("VoiceOverlayController", "Dialog already showing, skipping")
                return
            }
            if (activity.isFinishing || activity.isDestroyed) {
                android.util.Log.w("VoiceOverlayController", "Activity finishing/destroyed, cannot show dialog")
                return
            }
            
            // Dismiss any existing dialog first
            dialog?.dismissAllowingStateLoss()
            
            android.util.Log.d("VoiceOverlayController", "Creating new VoiceOverlayDialogFragment")
            dialog = VoiceOverlayDialogFragment(
                onCallCaregiver = onCall,
                onImOk = onOk,
                onTurnOnLight = onTurnOnLight,
                onHealthReport = onHealthReport,
                onCallGrandPaLi = onCallGrandPaLi
            )
            val fragmentManager = activity.supportFragmentManager
            
            android.util.Log.d("VoiceOverlayController", "FragmentManager state saved: ${fragmentManager.isStateSaved}")
            
            // Use show() method which handles state automatically
            try {
                if (!fragmentManager.isStateSaved) {
                    android.util.Log.d("VoiceOverlayController", "Calling dialog.show()")
                    dialog?.show(fragmentManager, "va_dialog")
                    android.util.Log.d("VoiceOverlayController", "dialog.show() completed")
                } else {
                    android.util.Log.w("VoiceOverlayController", "FragmentManager state saved, cannot show dialog")
                }
            } catch (e: Exception) {
                android.util.Log.e("VoiceOverlayController", "Failed to show dialog: ${e.message}", e)
                e.printStackTrace()
            }
        } catch (e: Exception) {
            android.util.Log.e("VoiceOverlayController", "Failed to show dialog (outer catch): ${e.message}", e)
            e.printStackTrace()
        }
    }

    fun dismiss() {
        try {
            android.util.Log.d("VoiceOverlayController", "dismiss called, dialog=${dialog?.isAdded}")
            dialog?.dismissAllowingStateLoss()
            dialog = null
            android.util.Log.d("VoiceOverlayController", "Dialog dismissed and cleared")
        } catch (e: Exception) {
            android.util.Log.e("VoiceOverlayController", "Failed to dismiss dialog: ${e.message}", e)
        }
    }

    fun updateRecognizedText(text: String) {
        try {
            android.util.Log.d("VoiceOverlayController", "updateRecognizedText called with: '$text', dialog=${dialog?.isAdded}, dialog=${dialog?.dialog?.isShowing}")
            if (dialog?.isAdded == true || dialog?.dialog?.isShowing == true) {
                android.util.Log.d("VoiceOverlayController", "Dialog is active, calling updateRecognizedText")
                dialog?.updateRecognizedText(text)
            } else {
                android.util.Log.w("VoiceOverlayController", "Dialog not added or not showing, cannot update text. dialog=${dialog}, isAdded=${dialog?.isAdded}, isShowing=${dialog?.dialog?.isShowing}")
            }
        } catch (e: Exception) {
            android.util.Log.e("VoiceOverlayController", "Failed to update recognized text: ${e.message}", e)
            e.printStackTrace()
        }
    }

    /** Fuzzy match: "hi dora" variants, tolerant to spacing/noise */
    fun isWake(text: String): Boolean {
        val s = text.lowercase()
        return s.replace("[^a-z]".toRegex(), "")
            .contains("hidora") || s.contains("hey dora") || s.contains("hi dora")
    }
}

