package com.example.a333

import java.util.Calendar

enum class EventType {
    BIRTHDAY,
    APPOINTMENT,
    REMINDER,
    MEDICATION
}

data class CalendarEvent(
    val id: String,
    val title: String,
    val type: EventType,
    val date: Calendar,
    val time: String, // Format: "HH:mm"
    val description: String = "",
    val isRecurring: Boolean = false, // For birthdays, recurring appointments
    val reminderMinutes: Int = 30 // Reminder before event (in minutes)
) {
    fun getDisplayText(): String {
        return "$time – $title"
    }
    
    fun getColorHex(): String {
        return when (type) {
            EventType.BIRTHDAY -> "#FECBA1" // Orange
            EventType.APPOINTMENT -> "#BEE3F8" // Blue
            EventType.REMINDER -> "#D1FAE5" // Green
            EventType.MEDICATION -> "#FECACA" // Red
        }
    }
}

