function plot_sketch(W_span, L_tot, D_b, sweep_LE, taper, C_r, cone_Angle_F, cone_Angle_R, LE_percent, S_tail, AR_tail, LE_sweep_tail, lambda_tail)

% Parametri geometrici input
% 
% W_span = 35;            % apertura alare [m]
% L_tot = 115;           % lunghezza fusoliera [m]
% sweep = 40;        % angolo di freccia [deg]
% taper = 0.154;     % rapporto rastremazione
% C_r = 28;           % corda radice [m]
% D_b = 5;           % larghezza centrale [m]
% cone_Angle_F = 4;    % semicono anteriore (gradi)
% cone_Angle_R = 10;    % semicono posteriore (gradi)
% LE_percent = 0.41; % posizione leading edge percentuale

%% Relazioni

sweep_LE= pi/2 - sweep_LE; % [rad] per averlo rispetto asse x
C_tip = C_r * taper;   % corda tip [m]
cone_L_F = D_b/(2*tan(cone_Angle_F)); % lunghezza semicono anteriore [m]
cone_L_R = D_b/(2*tan(cone_Angle_R)); % lunghezza semicono posteriore [m]
L_mid = L_tot-cone_L_F-cone_L_R; %lunghezza parte centrale fusoliera


x_start = 0;                     % punta davanti
x_fuse = L_tot - L_mid - cone_L_R;     % dove inizia la fusoliera centrale
x_fuse_end = L_tot - cone_L_R;         % fine fusoliera centrale
x_end = L_tot;   % punto finale coda

% Fusoliera centrale rettangolare
fuse_X = [x_fuse, x_fuse_end, x_fuse_end, x_fuse];
fuse_Y = [-D_b/2, -D_b/2, D_b/2, D_b/2];

% Semicono anteriore (triangolo)
nose_X = [x_start, x_fuse, x_fuse];
nose_Y = [0, -D_b/2, D_b/2];

% Semicono posteriore (triangolo)
tail_X = [x_fuse_end, x_end, x_fuse_end];
tail_Y = [-D_b/2, 0, D_b/2];

% Ali (come nello script base ma shiftate se la fusoliera non parte da 0)
y_left  = -W_span/2;
y_right =  W_span/2;
x_LE_root = L_tot * LE_percent;
x_LE_tip  = x_LE_root + W_span / (2* tan(sweep_LE));

X_wing = [x_LE_root, x_LE_tip, x_LE_tip + C_tip, x_LE_root + C_r, x_LE_tip + C_tip, x_LE_tip, x_LE_root];
Y_wing = [0, y_right, y_right, 0, y_left, y_left, 0];

%Tail
sweep_LE_tail = pi/2 - LE_sweep_tail;
b_tail = sqrt(AR_tail * S_tail);
C_med_tail = b_tail / AR_tail;
C_root_tail = C_med_tail / (2/3*(1+lambda_tail+lambda_tail^2)/(1+lambda_tail));
C_tip_tail = lambda_tail * C_root_tail;
X_LE_root_tail = x_end-C_root_tail;
X_LE_tip_tail = X_LE_root_tail + b_tail/(2*tan(sweep_LE_tail));

X_tail = [X_LE_root_tail,X_LE_tip_tail ,X_LE_tip_tail+C_tip_tail, X_LE_root_tail+C_root_tail, X_LE_tip_tail+C_tip_tail, X_LE_tip_tail, X_LE_root_tail];
Y_tail = [0, b_tail/2, b_tail/2, 0, -b_tail/2, -b_tail/2, 0];

figure; hold on; axis equal;
fill(X_wing, Y_wing, [0.7 0.7 1], 'EdgeColor','k','LineWidth',2); % Ala
fill(X_tail, Y_tail, [0.7 0.7 1], 'EdgeColor','k','LineWidth',2); %Tail
fill(fuse_X, fuse_Y, [0.8 0.8 0.8],'EdgeColor','k','LineWidth',1);% Fusoliera centrale
fill(nose_X, nose_Y, [0.6 0.6 0.6],'EdgeColor','k','LineWidth',1);% Semicono anteriore
fill(tail_X, tail_Y, [0.6 0.6 0.6],'EdgeColor','k','LineWidth',1);% Semicono posteriore
xlabel('X [m]'); ylabel('Y [m]');
title('Sketch LNG');


end