function [m_2, m_3] = plot_payload_range(W_pay, W_fuel, MTOW, Range_cruise, M, ISP, tau)

    % Calcolo punto D

    gamma = 1.4;
    R = 287;
    h_cruise = 28000;
    T_cruise = isa_temp(h_cruise);
    a_cruise = sqrt( gamma * R * T_cruise);
    V_cruise = M * a_cruise;
    m_21 = 0.97;
    m_32 = 0.88;
    m_54 = 0.985;
    m_65 = 0.995;

    if (ISP>= 2500) && (ISP<=3100)
        m_21 = 1 - (1-m_21) / 2.75;
        m_32 = 1 - (1-m_32) / 2.75;
        m_54 = 1 - (1-m_54) / 2.75;
        m_65 = 1 - (1-m_65) / 2.75;
    elseif (ISP>= 1200) && (ISP<= 1500)
        m_21 = 1 - (1-m_21) / 1.25;
        m_32 = 1 - (1-m_32) / 1.25;
        m_54 = 1 - (1-m_54) / 1.25;
        m_65 = 1 - (1-m_65) / 1.25;
    end
    Range_tot = 10000; % Range dato in input è solo crociera

    OEW = MTOW - W_pay -W_fuel;
    fuel_taxi = (OEW + W_fuel) * (1-m_21);
    fuel_climb = (OEW + W_fuel) * (1-m_32);
    fuel_descent = (OEW + W_fuel) * (1-m_54);
    fuel_landing = (OEW + W_fuel) * (1-m_65);
    m_2 = OEW + W_fuel - fuel_taxi - 0.6* fuel_climb; % mass at Mach 3 during climb
    m_3 = OEW + W_fuel - fuel_taxi - fuel_climb; % mass beginning of the cruise
    m_4 = OEW + fuel_descent + fuel_landing; % mass at the end of the cruise
    
    A = 6;
    B = 2;
    E = A*(M + B)/M * ((1.0128 - 0.2797 * log(tau/0.03) / (1 - M^2/673) ));
    Range_cruise_D = ISP*V_cruise*E / 1000 * log(m_3/m_4);
    Range_D = Range_tot - Range_cruise + Range_cruise_D;
    
    R = [0, Range_tot, Range_D];
    P = [W_pay, W_pay, 0];
    labels = {'A', 'B', 'D'};
    
    figure
    plot(R, P, '-x','LineWidth',2);
    grid on;
    hold on;
    xlabel('Range [km]');
    ylabel('Payload Mass [kg])');
    title('Payload Weight vs Range');
    
    for i = 1:length(R)
        text(R(i), P(i), labels{i}, 'VerticalAlignment', 'bottom', 'HorizontalAlignment', 'left','FontSize', 12);
    end
    
    hold off;

    figure
    hold on;
    grid on;
    plot(R, P, '-*','LineWidth',2);
    plot(R,[0,W_fuel,W_fuel],'-*','LineWidth',2);
    plot(R,P+[0,W_fuel,W_fuel],'-*','LineWidth',2);
    xlabel('Range [km]');
    ylabel('Mass [kg]');
    legend('Payload', 'Fuel','Payload and Fuel', 'Location','northwest');
    title('Payload and Fuel vs Range');
    hold off


end

function T = isa_temp(h)
    if h < 11000
        T = 288.15 - 0.0065 * h;
    elseif h < 20000
        T = 216.65;
    elseif h < 32000
        T = 216.65 + 0.001 * (h - 20000);
    else
        T = 270;
    end
end