function plot_matching_chart(S_ref, Wing_load,m_startclimb, m_startcruise)

gamma = 1.4;
R = 287;
rho0 = 1.225;
g = 9.81;

l_to=3000;
l_LO = 0.6 * l_to; % m, old 2600
CL_LO = 0.46; % CL 0.46 a Mach 0.35, in tabella finale Cl_to 0.63
%V_LO = 110.7; % m/s
%Vs = 87.2; % m/s

Neng = 4;
G2nd = 0.03; 
E2nd = 4.8; % from asset parametric analysis
h_2nd = 200;
[rho_2nd, T_2nd, sigma_2nd] = isa_atmosphere(h_2nd);


h_subclimb = 3500; % m
[rho_subclimb, T_subclimb, sigma_subclimb] = isa_atmosphere(h_subclimb);
M_subclimb = 0.65;
G_subclimb = 0.02; 
CD0 = 0.02; % a 4 grad 0.0183, a 8 gradi 0.045
Pi_subclimb = 1;


h_subcruise = 7000; % m
[rho_subcruise, T_subcruise, sigma_subcruise] = isa_atmosphere(h_subcruise);
M_subcruise = 0.9;
%CD_subcruise = ;


k_app = 1.7;
CL_app = 0.56; %0.46 hycat1
l_lfl = 3200;
%l_lfl = 1.667*l_ld;
%V_app = 96;
CL_max = 1.3^2 * CL_app; % pag 39


%h_boc_sup = 7000;
h_superclimb = 18500;
CD_sup = 0.0203; % 0.043 con alpha 8 gradi e 0.0203 per alpha 4 gradi
G_superclimb = 0.014;
M_superclimb = 3;


h_boc_hyp = 24500;
h_iperclimb = 26000;
M_iperclimb = 5.5;
CD_iperclimb = 0.0146;
G_iperclimb = 0.014;

h_hypercruise = 28600;
M_hypercruise = 6;
CD_hypercruise = 0.0142;

WS_range = linspace(50, 700, 200);

mach2vel = @(M, T) M .* sqrt(gamma * R .* T);

% SUBSONIC

%% --- Take-off (sub) ---

TW_takeoff = @(WS) WS./ (rho0 * l_LO * CL_LO);

%% --- Second segment (sub) ---

TW_2nd = Neng/(Neng-1) * (1/E2nd + G2nd) / sigma_2nd;

%% ---  Climb (sub) ---

V_subclimb = mach2vel(M_subclimb, T_subclimb);
q_subclimb = 0.5* rho_subclimb * (V_subclimb)^2;

TW_subclimb = @(WS) ((q_subclimb.* CD0)./ (WS.* g) + G_subclimb)./ (sigma_subclimb * Pi_subclimb);

%% --- Cruise (sub) ---

V_subcruise = mach2vel(M_subcruise, T_subcruise);
q_subcruise = 0.5* rho_subcruise * (V_subcruise)^2;

TW_subcruise_BR = @(WS) ((4/3 * q_subcruise.* CD0)./( WS.* g))./ sigma_subcruise;
%TW_subcruise_BE = @(WS) ((2 * q_subcruise.* CD0)./( WS.* g))./ sigma_cruise;

% Stall Speed (sub)

% WS_stall = 0.5*rho0 * CL_max * Vs^2 / g;

%% --- Landing (sub) ---

%WS_landing = 0.5 * rho0 * CL_max * V_app^2 / g;
WS_landing = rho0 * CL_app * k_app^2 * l_lfl /(2*g);

% --- Grafico subsonico ---
figure;
hold on;
grid on;

plot(WS_range, TW_takeoff(WS_range), 'g', 'LineWidth', 2);
plot(WS_range, TW_2nd * ones(size(WS_range)), 'c', 'LineWidth', 2);
plot(WS_range, TW_subclimb(WS_range), 'r', 'LineWidth', 2);
plot(WS_range, TW_subcruise_BR(WS_range), 'b', 'LineWidth', 2);
%plot(WS_range, TW_subcruise_BE(WS_range), 'y', 'LineWidth', 2);
%xline(WS_stall,'--' ,'LineWidth',2);
xline(WS_landing, '--k','LineWidth',2);
xline(Wing_load, '--m', 'LineWidth', 2);

% Etichette e legenda
xlabel('Wing Loading W/S (kg/m^2)');
ylabel('Thrust-to-Weight T/W');
title('Matching Chart Subsonic Speed');

legend( 'Takeoff', 'Second Segment', 'Climb', 'Cruise Best Range', 'Landing', 'W/S' , 'Location', 'northeast');

hold off;


%% SUPERSONIC

% --- Climb (super) ---

[rho_superclimb, T_superclimb, sigma_superclimb] = isa_atmosphere(h_superclimb);
V_superclimb = mach2vel(M_superclimb, T_superclimb);
q_superclimb = 0.5 * rho_superclimb * (V_superclimb)^2;
%[rho_boc_sup, T_boc_sup, sigma_boc_sup] = isa_atmosphere(h_boc_sup);

TW_superclimb = @(WS) ((q_superclimb * CD_sup)./ (WS * g) + G_superclimb);


% --- Grafico supersonico ---
figure;
hold on;
grid on;

plot(WS_range, TW_superclimb(WS_range),'r', 'LineWidth',2);
xline(m_startclimb/S_ref, '--m', 'LineWidth', 2);

% Etichette e legenda
xlabel('Wing Loading W/S (kg/m^2)');
ylabel('Thrust-to-Weight T/W');
title('Matching Chart Supersonic Speed');

legend('Climb', 'Wing Loading');

hold off;



%% HYPERSONIC

% --- Climb (hyper) ---
[rho_hyperclimb, T_hyperclimb, sigma_hyperclimb] = isa_atmosphere(h_iperclimb);
V_hyperclimb = mach2vel(M_iperclimb, T_hyperclimb);
q_hyperclimb = 0.5 * rho_hyperclimb * (V_hyperclimb)^2;
[rho_toc_hyp, T_toc_hyp, sigma_toc_hyp] = isa_atmosphere(h_hypercruise);

TW_hyperclimb = @(WS) ((q_hyperclimb * CD_iperclimb)./ (WS * g) + G_iperclimb) / (rho_hyperclimb/rho_toc_hyp);

% --- Cruise (hypersonic) ---

[rho_hypercruise, T_hypercruise, sigma_hypercruise] = isa_atmosphere(h_hypercruise);
V_hypercruise = mach2vel(M_hypercruise, T_hypercruise);
q_hypercruise = 0.5 * rho_hypercruise * (V_hypercruise)^2;

TW_hypercruise = @(WS) ((q_hypercruise * CD_hypercruise)./ (WS * g)); % * (rho_hypercruise/rho_boc_hyp);


% --- Grafico ipersonico ---

figure;
hold on;
grid on;

plot(WS_range, TW_hyperclimb(WS_range), 'LineWidth', 2);
plot(WS_range, TW_hypercruise(WS_range),'b', 'LineWidth',2);
xline(m_startcruise/S_ref, '--m', 'LineWidth', 2);

% Etichette e legenda
xlabel('Wing Loading W/S (kg/m^2)');
ylabel('Thrust-to-Weight T/W');
title('Matching Chart Hypersonic Speed');

legend('Climb', 'Cruise', 'Wing Loading');

hold off;


% % --- Grafico combinato ---
% figure;
% hold on;
% grid on;
% 
% % --- Matching chart subsonico ---
% plot(WS_range, TW_takeoff(WS_range), 'g', 'LineWidth', 2);
% plot(WS_range, TW_2nd * ones(size(WS_range)), 'c', 'LineWidth', 2);
% plot(WS_range, TW_subclimb(WS_range), 'r', 'LineWidth', 2);
% plot(WS_range, TW_subcruise_BR(WS_range), 'b', 'LineWidth', 2);
% % plot(WS_range, TW_subcruise_BE(WS_range), 'y', 'LineWidth', 2); % opzionale
% xline(WS_landing, '--k', 'LineWidth', 2);
% 
% % --- Matching chart supersonico ---
% plot(WS_range, TW_superclimb(WS_range), 'LineWidth', 2);
% plot(WS_range, TW_supercruise(WS_range), 'LineWidth', 2);
% 
% % --- Linea Wing load comune ---
% xline(Wing_load, '--m', 'LineWidth', 2);
% 
% % Etichette e legenda
% xlabel('Wing Loading W/S (N/m^2)');
% ylabel('Thrust-to-Weight T/W');
% title('Matching Chart Subsonic + Supersonic');
% 
% legend('Takeoff', 'Second Segment', 'Sub Climb', 'Sub Cruise Best Range', ...
%     'Landing', 'Super Climb', 'Super Cruise', ...
%     'W/S', 'Location', 'northeast');
% 
% hold off;

end


% ISA_ATMOSPHERE  Calcola i parametri ISA in funzione della quota

function [rho, T, sigma] = isa_atmosphere(h)
% Input:
%   h     quota [m]
%
% Output:
%   rho   densità [kg/m^3]
%   T     temperatura [K]
%   sigma rapporto di densità rho/rho0

    % Costanti ISA
    T0   = 288.15;        % Temperatura al livello del mare [K]
    p0   = 101325;        % Pressione al livello del mare [Pa]
    rho0 = 1.225;         % Densità al livello del mare [kg/m^3]
    g    = 9.80665;       % Gravità [m/s^2]
    R    = 287.05287;     % Costante gas aria secca [J/(kg*K)]

    % Quote dei principali strati [m]
    h_trop = 11000;   % Tropopausa
    h_iso  = 20000;   % Fine strato isoterma
    h_str1 = 32000;   % Fine primo strato stratosferico

    % Gradienti [K/m]
    L_trop = -0.0065;   % 0–11 km
    L_iso  = 0.0;       % 11–20 km
    L_str1 = 0.001;     % 20–32 km

    % -------------------------
    if h <= h_trop
        % Troposfera
        T = T0 + L_trop*h;
        p = p0 * (T/T0)^(-g/(L_trop*R));
    elseif h <= h_iso
        % Tropopausa (isoterma)
        T = T0 + L_trop*h_trop;
        p_trop = p0 * (T/T0)^(-g/(L_trop*R));
        p = p_trop * exp(-g*(h-h_trop)/(R*T));
    elseif h <= h_str1
        % Stratosfera bassa (20–32 km, gradiente positivo)
        T_trop = T0 + L_trop*h_trop;
        p_trop = p0 * (T_trop/T0)^(-g/(L_trop*R));
        p_iso  = p_trop * exp(-g*(h_iso-h_trop)/(R*T_trop));

        T = T_trop + L_str1*(h-h_iso);
        p = p_iso * (T/T_trop)^(-g/(L_str1*R));
    else
        error('Quota fuori range: funzione valida fino a 32 km');
    end

    % Densità
    rho = p/(R*T);

    % Rapporto rispetto a SL
    sigma = rho/rho0;
end
