clc
clear all
close all

filename = 'input_list.xlsx';
data = readtable(filename, 'VariableNamingRule', 'preserve');

% Estrai i nomi dei veicoli dalle intestazioni delle colonne (colonne 2 a 6)
vehicleNames = data.Properties.VariableNames(2:6);  % Ignora la colonna 'INPUT_LIST'

% Mostra le opzioni all'utente
fprintf('Seleziona un velivolo tra i seguenti:\n');
for j = 1:length(vehicleNames)
    fprintf('%2d: %s\n', j, vehicleNames{j});
end

% Richiedi la selezione all'utente
 x = input('Inserisci il numero corrispondente al velivolo desiderato: ');
%x=2;

% Verifica che l'indice sia valido
if x < 1 || x > length(vehicleNames)
    error('Indice non valido. Seleziona un numero tra 1 e %d.\n', length(vehicleNames));
end

% Ottiene i nomi delle variabili dalla prima colonna
%varNames = data.INPUT_LIST; 

fullNames = data.("INPUT_LIST");
varNames = strings(size(fullNames));

for k = 1:length(fullNames)
    splitStr = split(fullNames{k}, ',');      % Separa per virgola
    cleanName = strtrim(splitStr{1});         % Prendi solo il nome, rimuovi spazi
    varNames(k) = matlab.lang.makeValidName(cleanName);  % Nome valido per MATLAB
end

% Estraggo solo i dati numerici
colName = vehicleNames{x};                   % Nome della colonna scelta
values = data{:,colName};

for i = 1:length(varNames)
    vec =  values(i);         % assegna valore alla prima posizione
    assignin('base', varNames(i), vec); % crea la variabile nel workspace

end


rho_air = 0.0184 * 0.062428; % sea level in lb / ft^3


theta_r = deg2rad(theta_r);
theta_f = deg2rad(theta_f);
lambda_mezzi = deg2rad(lambda_mezzi);

W_pay = rho_Wpay * Passengers;
V_pay = W_pay/ rho_Vpay;

%rho_fuel = 450 * 0.062428; % 450 kg/m^3 a -161.5 °C


%% Prima stima pesi con dati geometrici di input

W_S(1) = Wing_load;
S_ref(1) = W_gtot(1) / Wing_load;

W_b(1) = 0.341 * mf * ((L_b(1) * ULF / D_be(1)) ^ 0.15 * Q_max ^ 0.16 * Sb_tot(1) ^ 1.05);

W_fuel(1) = W_gtot(1) * Fuel_perc;

W_tnk(1) = W_fuel(1) / rho_fuel * rho_tnk;

W_emp(1) = W_gtot(1) - W_fuel(1) - (1-delta) * W_tnk(1);


W_w(1) = 0.2958 * mf * (((W_emp(1) * ULF) / 1000 )^0.52 * ...
             S_ref(1)^0.7 * AR^0.47 * ((1 + lambda) / t_c)^0.4 * ...
             (0.3 + 0.7 / cos(lambda_mezzi)))^1.017;

S_wfh(1) = A_hfp * S_ref(1);
S_wfv(1) = A_vfp * S_ref(1);

W_finh(1) = 0.0035 * (W_gtot(1) / S_ref(1))^0.6 * S_wfh(1)^1.2 * Q_max^0.8;

W_finv(1) = 5 * S_wfv(1)^1.09;

S_tb(1) = Sb_tot(1)/2;

W_tps(1) = W_ins * (S_tb(1) + S_ref(1) + S_wfh(1));

W_gear(1) = 0.00916 * W_gtot(1)^1.124;

W_thrua(1) = 0.00625 * T_tott + 69;

W_str(1) = W_b(1) + W_w(1) + W_finh(1) + W_finv(1) + W_tps(1) + W_gear(1) + W_thrua(1);

% Propulsion weight

W_ttj(1) = N_engtj * (W_a*133.3 - 16600)/4;

W_ttr(1) = N_engtr * 1782.63 * exp(0.003 * W_a);

W_trj(1) = 0.01 * T_tott;

W_tsj(1) = N_engsj * (87.5 * H_tsjm - 850);

W_eng(1) = W_ttj(1) + W_ttr(1) + W_trj(1) + W_tsj(1);

W_pros(1) = W_tnk(1) + W_eng(1);

% Subsystem Weight

W_hydr(1) = 2.64 * ((S_ref(1) + S_wfv(1) + S_wfh(1)) * Q_max / 1000)^0.334 * (L_b(1) + W_span(1))^0.5; 

W_taves(1) = 66.37 * W_gtot(1)^0.361;

W_elect(1) = 1.167 * W_gtot(1)^0.5 * L_b(1)^0.25; 

W_equip(1) = 10000 + 0.01 * (W_gtot(1) - 0.0000003); 

W_sub(1) = W_hydr(1) + W_taves(1) + W_elect(1) + W_equip(1);
 
% W_gtot(2) = W_fuel(1) + W_str(1) + W_pay + W_pros(1) + W_sub(1);
% 
% 
% V_tot(2) = (W_gtot(2) - delta * (W_fuel(1) + W_tnk(1)) - W_pay - W_tps(1))/rho_a ...
%          + delta * W_fuel(1)/rho_fuel + V_pay;


%% Inizializzazione primo ciclo 

kn(1) = D_be(1) * abs( 2*pi*( 1/(6*tan(theta_f)) + A_lorb/2 + 1/(6*tan(theta_r))) / V_tot(1) )^(1/3) - 1; 

kb(1) = D_be(1) / (1 + kn(1)) * (1/tan(theta_f) + A_lorb + 1/tan(theta_r)) / L_b(1);

kc(1) = 2 * D_be(1)^2 / ((1 + kn(1))^2 * (3.309 * sqrt(L_b(1) * V_tot(1)))) ...
    * ( (pi/2)/sin(theta_f) + pi*A_lorb + (pi/2)/sin(theta_r) );


% 1. Lenght of the body Lb

L_b(2) = kb(1) * (((F_r(1))^2 * V_tot(1)) / ((pi/4) * eta_vol))^(1/3);

% 2. Body equivalent diameter Dbe

D_be(2) = sqrt( V_tot(1) / ((pi/4) * eta_vol * L_b(2) ));

% 3. Vehicle fineness ratio

F_r(2) = L_b(2) / D_be(2);

% 4. Body width

B_b(2) = (2 * D_be(2)) / (1 + kn(1));

% 5. Total wetted area of the body Sb,tot

Sb_tot(2) = 3.309 * kc(1) * sqrt( L_b(2) * V_tot(1) );

S_ref(2) = W_gtot(1) / Wing_load;

W_span(2) = sqrt( S_ref(2) * AR );


%% Weight analysis

% Body weight W_b
W_b(2) = 0.341 * mf * abs((L_b(2) * ULF / D_be(2))^0.15 * Q_max ^ 0.16 * Sb_tot(2)^1.05);

% Wing weight W_w

W_fuel(2) = W_gtot(1) * Fuel_perc;

W_tnk(2) = W_fuel(2)/rho_fuel * rho_tnk; % tank weight

W_emp(2) = W_gtot(1) - W_fuel(2) - (1-delta) * W_tnk(2); 

% W_emp(2) = W_gtot(1) - W_fuel(2);

W_w(2) = 0.2958 * mf * (((W_emp(2) * ULF) / 1000)^0.52 * ...
         S_ref(2)^0.7 * AR^0.47 * ((1 + lambda) / t_c)^0.4 * ...
         (0.3 + 0.7 / cos(lambda_mezzi)))^1.017;

% Tail weight

S_wfh(2) = A_hfp * S_ref(2);
S_wfv(2) = A_vfp * S_ref(2);

W_finh(2) = 0.0035 * (W_gtot(1) / S_ref(2)) ^ 0.6 * S_wfh(2) ^ 1.2 * Q_max ^ 0.8;
W_finv(2) = 5 * S_wfv(2) ^ 1.09;

% Termal protection system weight
S_tb(2) = Sb_tot(2)/2;

W_tps(2) = W_ins * (S_tb(2) + S_ref(2) + S_wfh(2));

% Landing gear weight
W_gear(2) = 0.00916 * W_gtot(1)^1.124;

% Thrust structure weight
W_thrua(2) = 0.00625 * T_tott + 69;

% Total Structural Weight
W_str(2) = W_b(2) + W_w(2) + W_finh(2) + W_finv(2) + W_tps(2) + W_gear(2) + W_thrua(2);

%% Propulsion weight

%Turbojet weight equation
W_ttj(2) = N_engtj * (W_a * 133.3 - 16600)/4;

%Turboramjet weight equation
W_ttr(2) = N_engtr * 1782.63 * exp(0.003 * W_a);

% Ramjet weight equation
W_trj(2) = 0.01 * T_tott;

% Scramjet (6 < Mach < 14) equation
W_tsj(2) = N_engsj * (87.5 * H_tsjm - 850);

W_eng(2) = W_ttj(2) + W_ttr(2) + W_trj(2) + W_tsj(2);

% Total propulsion weight
W_pros(2) = W_tnk(2) + W_eng(2);

%% Subystem Weight

%hydraulic weight
W_hydr(2) = 2.64 * ((S_ref(2) + S_wfv(2) + S_wfh(2)) * Q_max / 1000)^0.334 * (L_b(2) + W_span(2))^0.5; 

%avionics weight
W_taves(2) = 66.37 * W_gtot(1)^0.361;

% electrical system weight
W_elect(2) = 1.167 * W_gtot(1)^0.5 * L_b(2)^0.25; 

%  equipment weight
W_equip(2) = 10000 + 0.01 * (W_gtot(1) - 0.0000003); 

% Total subsystem weight
W_sub(2) = W_hydr(2) + W_taves(2) + W_elect(2) + W_equip(2);

%% Total Vehicle Gross Weight   

W_gtot(2) = W_fuel(2) + W_str(2) + W_pay + W_pros(2) + W_sub(2);

% V_af(2) = pi * (D_be(2) / 2)^2 * L_b(2);

V_tot(2) = (W_gtot(2) - delta * (W_fuel(2) + W_tnk(2)) - W_pay - W_tps(2))/rho_a ...
         + delta * W_fuel(2)/rho_fuel + V_pay;
%}

max_iter = 2000;
tol = 10;


%{

for (i=2:max_iter)

    if ( abs( W_gtot(i) - W_gtot(i-1) ) <= tol)

        break

    end
    
    % Geometry parameters

    L_b(i) = kb(i-1) * ((F_r(1)^2 * V_tot(i)) / ((pi/4) * eta_vol))^(1/3);
   
    D_be(i) = sqrt(V_tot(i) / ((pi/4) * eta_vol * L_b(i)));
    
    F_r(i) = L_b(i) / D_be(i); 
    
    B_b(i) = (2 * D_be(i)) / (1 + kn(i-1));

    Sb_tot(i) = 3.309 * kc(i-1) * sqrt(L_b(i) * V_tot(i));
   
    S_ref(i) = W_gtot(i)/Wing_load;

    W_span(i) = sqrt(S_ref(i)*AR);

    %% Weight analysis
    
    W_b(i) = 0.341 * mf * abs((L_b(i) * ULF / D_be(i)) ^ 0.15 * Q_max ^ 0.16 * Sb_tot(i) ^ 1.05);
    
    W_fuel(i) = W_gtot(i) * Fuel_perc;
    
    W_tnk(i) = W_fuel(i) / rho_fuel * rho_tnk;
   
    W_emp(i) = W_gtot(i) - W_fuel(i) - (1-delta) * W_tnk(i);
    
    W_w(i) = 0.2958 * mf * (((W_emp(i) * ULF) / 1000 )^0.52 * ...
                 S_ref(i)^0.7 * AR^0.47 * ((1 + lambda) / t_c)^0.4 * ...
                 (0.3 + 0.7 / cos(lambda_mezzi)))^1.017;
    
    S_wfh(i) = A_hfp * S_ref(i);
    S_wfv(i) = A_vfp * S_ref(i);
    
    W_finh(i) = 0.0035 * (W_gtot(i) / S_ref(i))^0.6 * S_wfh(i)^1.2 * Q_max^0.8;

    W_finv(i) = 5 * S_wfv(i)^1.09;
    
    S_tb(i) = Sb_tot(i)/2;
    
    W_tps(i) = W_ins * (S_tb(i) + S_ref(i) + S_wfh(i));
    
    W_gear(i) = 0.00916 * W_gtot(i)^1.124;
    
    W_thrua(i) = 0.00625 * T_tott + 69;
    
    W_str(i) = W_b(i) + W_w(i) + W_finh(i) + W_finv(i) + W_tps(i) + W_gear(i) + W_thrua(i);
    
    % Propulsion weight
    
    W_ttj(i) = N_engtj * (W_a * 133.3 - 16600)/4;
    
    W_ttr(i) = N_engtr * 1782.63 * exp(0.003 * W_a);
    
    W_trj(i) = 0.01 * T_tott;
    
    W_tsj(i) = N_engsj * (87.5 * H_tsjm - 850);
    
    W_eng(i) = W_ttj(i) + W_ttr(i) + W_trj(i) + W_tsj(i);
    
    W_pros(i) = W_tnk(i) + W_eng(i);
    
    % Subsystem Weight
    
    W_hydr(i) = 2.64 * ((S_ref(i) + S_wfv(i) + S_wfh(i)) * Q_max / 1000)^0.334 * (L_b(i) + W_span(i))^0.5; 
    
    W_taves(i) = 66.37 * W_gtot(i)^0.361;
    
    W_elect(i) = 1.167 * W_gtot(i)^0.5 * L_b(i)^0.25; 
    
    W_equip(i) = 10000 + 0.01 * (W_gtot(i) - 0.0000003); 
    
    W_sub(i) = W_hydr(i) + W_taves(i) + W_elect(i) + W_equip(i);
    
    W_gtot(i+1) = W_fuel(i) + W_str(i) + W_pay + W_pros(i) + W_sub(i);
    
    V_tot(i+1) = (W_gtot(i+1) - delta * (W_fuel(i) + W_tnk(i)) - W_pay - W_tps(i))/rho_a ...
           + delta * W_fuel(i)/rho_fuel + V_pay;


    kn(i) = D_be(i) * abs (2*pi* (1/(6*tan(theta_f)) + A_lorb/2 + 1/(6*tan(theta_r))) / ((W_gtot(i) - delta * W_fuel(i) - W_pay)/rho_a ...
               + delta * W_fuel(i)/rho_fuel + V_pay))^(1/3) - 1;

    % kn(i) = D_be(i) * abs(2*pi* (1/(6*tan(theta_f)) + A_lorb/2 + 1/(6*tan(theta_r))) / (V_tot(i)) )^(1/3) - 1; 

    kb(i) = D_be(i) / (1 + kn(i)) * (1/tan(theta_f) + A_lorb + 1/tan(theta_r)) / L_b(i);
    
    kc(i) = ( (2*D_be(i)^2 / (1 + kn(i))^2) * ( (pi/2)/sin(theta_f) + pi*A_lorb + (pi/2)/sin(theta_r) ) ) ...
          / (3.309 * sqrt(L_b(i) * V_tot(i)));



end

%}



for (i=2:max_iter)

    if (abs(W_gtot(i)-W_gtot(i-1)) <= tol)

        break

    end


    %kn(i) = D_be(i) * abs(2*pi* (1/(6*tan(theta_f)) + A_lorb/2 + 1/(6*tan(theta_r))) / ((W_gtot(i) - delta * W_fuel(i) - W_pay)/rho_a ...
    %           + delta * W_fuel(i)/rho_fuel + V_pay + V_af(i) ))^(1/3) - 1;

    kn(i) = D_be(i) * abs(2*pi* (1/(6*tan(theta_f)) + A_lorb/2 + 1/(6*tan(theta_r))) / (V_tot(i)) )^(1/3) - 1; 

    kb(i) = D_be(i) / (1 + kn(i)) * (1/tan(theta_f) + A_lorb + 1/tan(theta_r)) / L_b(i);
    
    kc(i) = ( (2*D_be(i)^2 / (1 + kn(i))^2) * ( (pi/2)/sin(theta_f) + pi*A_lorb + (pi/2)/sin(theta_r) ) ) ...
          / (3.309 * sqrt(L_b(i) * V_tot(i)));
    

    % Geometry parameters

    L_b(i+1) = kb(i) * ((F_r(1)^2 * V_tot(i)) / ((pi/4) * eta_vol))^(1/3);
   
    D_be(i+1) = sqrt(V_tot(i) / ((pi/4) * eta_vol * L_b(i+1)));
    
    F_r(i+1) = L_b(i+1) / D_be(i+1); 
    
    B_b(i+1) = (2 * D_be(i+1)) / (1 + kn(i));

    Sb_tot(i+1) = 3.309 * kc(i) * sqrt(L_b(i+1) * V_tot(i));
    
    S_ref(i+1) = W_gtot(i)/Wing_load;

    W_span(i+1) = sqrt(S_ref(i+1) * AR);


    % Weight analysis

    W_b(i+1) = 0.341 * mf * abs((L_b(i+1) * ULF / D_be(i+1)) ^ 0.15 * Q_max ^ 0.16 * Sb_tot(i+1) ^ 1.05);
    
    W_fuel(i+1) = W_gtot(i) * Fuel_perc;
    
    W_tnk(i+1) = W_fuel(i+1) / rho_fuel * rho_tnk;
   
    W_emp(i+1) = W_gtot(i) - W_fuel(i+1) - (1-delta) * W_tnk(i+1);
    
    W_w(i+1) = 0.2958 * mf * (((W_emp(i+1) * ULF) / 1000 )^0.52 * ...
                 S_ref(i+1)^0.7 * AR^0.47 * ((1 + lambda) / t_c)^0.4 * ...
                 (0.3 + 0.7 / cos(lambda_mezzi)))^1.017;

    
    S_wfh(i+1) = A_hfp * S_ref(i+1);
    S_wfv(i+1) = A_vfp * S_ref(i+1);
    
    W_finh(i+1) = 0.0035 * (W_gtot(i) / S_ref(i+1))^0.6 * S_wfh(i+1)^1.2 * Q_max^0.8;

    W_finv(i+1) = 5 * S_wfv(i+1)^1.09;
    
    S_tb(i+1) = Sb_tot(i+1)/2;
    
    W_tps(i+1) = W_ins * (S_tb(i+1) + S_ref(i+1) + S_wfh(i+1));
    
    W_gear(i+1) = 0.00916 * W_gtot(i)^1.124;
    
    W_thrua(i+1) = 0.00625 * T_tott + 69;
    
    W_str(i+1) = W_b(i+1) + W_w(i+1) + W_finh(i+1) + W_finv(i+1) + W_tps(i+1) + W_gear(i+1) + W_thrua(i+1);
    
    % Propulsion weight
    
    W_ttj(i+1) = N_engtj * (W_a * 133.3 - 16600)/4;
    
    W_ttr(i+1) = N_engtr * 1782.63 * exp(0.003 * W_a);
    
    W_trj(i+1) = 0.01 * T_tott;
    
    W_tsj(i+1) = N_engsj * (87.5 * H_tsjm - 850);
    
    W_eng(i+1) = W_ttj(i+1) + W_ttr(i+1) + W_trj(i+1) + W_tsj(i+1);
    
    W_pros(i+1) = W_tnk(i+1) + W_eng(i+1);
    
    % Subsystem Weight
    
    W_hydr(i+1) = 2.64 * ((S_ref(i+1) + S_wfv(i+1) + S_wfh(i+1)) * Q_max / 1000)^0.334 * (L_b(i+1) + W_span(i+1))^0.5; 
    
    W_taves(i+1) = 66.37 * W_gtot(i)^0.361;
    
    W_elect(i+1) = 1.167 * W_gtot(i)^0.5 * L_b(i+1)^0.25; 
    
    W_equip(i+1) = 10000 + 0.01 * (W_gtot(i) - 0.0000003); 
    
    W_sub(i+1) = W_hydr(i+1) + W_taves(i+1) + W_elect(i+1) + W_equip(i+1);
    
    % Total Vehicle Gross Weight
    
    W_gtot(i+1) = W_fuel(i+1) + W_pay + W_str(i+1) + W_pros(i+1) + W_sub(i+1);

    % V_af(i+1) = pi * (D_be(i+1)/2)^2 * L_b(i+1);

    V_tot(i+1) = (W_gtot(i+1) - delta * (W_fuel(i+1) + W_tnk(i+1)) - W_pay - W_tps(i+1))/rho_a ...
           + delta * W_fuel(i+1)/rho_fuel + V_pay;
    
    % V_tot(i+1) = (W_gtot(i+1) - delta * W_fuel(i+1) - W_pay)/rho_a ...
    %           + delta * W_fuel(i+1)/rho_fuel + V_pay;

    W_S(i+1) = W_gtot(i+1) / S_ref(i+1);

end

%}


% Elenco delle variabili da salvare
varNames = { ...
    'L_b',  'D_be', 'F_r', 'B_b' ,'W_span','W_S' ,'S_ref' ,'Sb_tot', ...
    'S_tb' ,'S_wfh', 'S_wfv', 'W_b', 'W_fuel', 'W_tnk', 'W_emp', ...
    'W_w' ,'W_finh' , 'W_finv', 'W_tps', 'W_gear', 'W_thrua', ...
    'W_str', 'W_ttj', 'W_ttr', 'W_trj', 'W_tsj', 'W_eng', 'W_pros', ...
    'W_hydr', 'W_taves', 'W_elect', 'W_equip', 'W_sub', ...
    'W_gtot', 'V_tot'};


% Fattori di conversione da imperiale a SI per ogni variabile
conversion_factors = [...
    0.3048;    % L_b → m
    0.3048;    % D_be → m
    1;         % F_r → (adimensionale)
    0.3048;    % B_b → m
    0.3048;    % W_span → m
    0.453592/0.092903; % lb/ft^2 → kg/m^2
    0.092903;  % S_ref → m²
    0.092903;  % Sb_tot → m²
    0.092903;  % S_tb → m²
    0.092903;  % S_wfh → m²
    0.092903;  % S_wfv → m²
    0.453592;  % W_b → kg
    0.453592;  % W_fuel → kg
    0.453592;  % W_tnk → kg
    0.453592;  % W_emp → kg
    0.453592;  % W_w → kg
    0.453592;  % W_finh → kg
    0.453592;  % W_finv → kg
    0.453592;  % W_tps → kg
    0.453592;  % W_gear → kg
    0.453592;  % W_thrua → kg
    0.453592;  % W_str → kg
    0.453592;  % W_ttj → kg
    0.453592;  % W_ttr → kg
    0.453592;  % W_trj → kg
    0.453592;  % W_tsj → kg
    0.453592;  % W_eng → kg
    0.453592;  % W_pros → kg
    0.453592;  % W_hydr → kg
    0.453592;  % W_taves → kg
    0.453592;  % W_elect → kg
    0.453592;  % W_equip → kg
    0.453592;  % W_sub → kg
    0.453592;  % W_gtot → kg
    0.0283168  % V_tot → m³
];


% Numero variabili e iterazioni
nVars = numel(varNames);
nIter = i;

% Prealloca matrice risultati
results = NaN(nVars, nIter);

% Seleziona le colonne da visualizzare: iterazioni 1, 2 e l'ultima
cols_to_show = [1,2, nIter];

% Riempi la matrice con i valori di ciascuna variabile per ogni iterazione
for v = 1:nVars
    varData = eval(varNames{v});  % recupera la variabile
    if numel(varData) >= nIter
        results(v, :) = varData(1:nIter);  % estrai fino all'iterazione corrente
    end
end

% Estrai i dati corrispondenti
results_to_show = results(:, cols_to_show);

% Applica la conversione
converted_results = results_to_show .* conversion_factors;

% Unisci originali + convertiti
all_data = [results_to_show, converted_results];

% Crea nomi colonne
colnames = { ...
    ['Iter_1'],['Iter_2'] , ['Iter_' num2str(i)], ...
    ['Iter_1_SI'], ['Iter_2'], ['Iter_' num2str(i) '_SI']};

% Mostra tabella
f = figure('Name', 'Conversione a Sistema Internazionale (SI)', 'NumberTitle', 'off');
uitable('Data', all_data, ...
        'RowName', varNames, ...
        'ColumnName', colnames, ...
        'Units', 'normalized', ...
        'Position', [0, 0, 1, 1]);

plot_matching_chart(S_ref(i)*0.092903, Wing_load*(0.453592/0.092903));
