
function visualize_components_full(M, labels)
% Visualizza 8 componenti di un modello ktensor (M).
% Per ogni componente crea una finestra con:
%   - istogramma neuroni
%   - profilo temporale
%   - scatter dei trials
% Alla fine crea una finestra con i soli 8 istogrammi neuroni.

    % Normalizza e fissa segni
    M = fixsigns(arrange(normalize(M,0)));
    U = M.U;
    R = size(U{1},2);

    % Colori per i trials (1=rosso, 2=blu)
    cmap = [1 0 0; 0 0 1];
    trialColors = cmap(labels, :);

    Rshow = R;

    % === Finestra per ciascun componente ===
    for r = 1:Rshow
        figure('Color','w','Name',sprintf('Componente %d',r));

        % Layout verticale: 3 righe, 1 colonna
        tl = tiledlayout(3,1,'Padding','compact','TileSpacing','compact');

        % --- Istogramma neuroni (bar plot) ---
        nexttile;
        bar(U{1}(:,r),'FaceColor',[0.3 0.3 0.3],'EdgeColor','none');
        xlabel('Neuron index'); ylabel('Loading');
        title(sprintf('Component %d – Neurons',r));

        % --- Profilo temporale ---
        nexttile;
        plot(U{2}(:,r),'LineWidth',1.5,'Color',[0 0.45 0.74]);
        xlabel('Time'); ylabel('Weight');
        title(sprintf('Component %d – Time',r));

        % --- Scatter trials ---
        nexttile;
        scatter(1:numel(labels), U{3}(:,r), 40, trialColors, 'filled');
        xlabel('Trial'); ylabel('Weight');
        title(sprintf('Component %d – Trials',r));

        title(tl, sprintf('Component %d',r));
    end

    % === Figura comparativa: 8 istogrammi neuroni ===
    figure('Color','w','Name','Neuron loadings (8 components)');
    tl = tiledlayout(2,4,'Padding','compact','TileSpacing','compact');

    for r = 1:Rshow
        nexttile;
        bar(U{1}(:,r),'FaceColor',[0.3 0.3 0.3],'EdgeColor','none');
        xlabel('Neuron index'); ylabel('Loading');
        title(sprintf('Comp %d',r));
    end
    title(tl,'Neuron loadings – 8 components');
end
