%funzione wiggle per disegnare le tracce sismiche in modalit wiggle + variable area
% wiggle(tracce,SR,X)
% tracce  la matrice delle tracce sismiche in colonna
% SR l'intervallo di campionamento in secondi
% X il vettore delle distanze dei ricevitori rispetto alla sorgente
% i parametri SR e X sono opzionali: quando non sono indiacati, si assume SR=1 X=1:ntracce



function wiggle_corr(a,SR,x)

plot(1)
zoom on;
[nz,nx]=size(a);
a=normit(a);
trmx= max(abs(a));
if (nargin < 3); x=[1:nx]; SR=1; end
z=(1:nz)*SR;

 % take the average as dx
	dx1 = abs(x(2:nx)-x(1:nx-1));
 	dx = mean(dx1);%gain
    
    a=a*dx*0.7;
   
    
 dz=z(2)-z(1);
 xmx=max(max(a)); xmn=min(min(a)); 

% set display range 
x1=min(x)-2.0*dx; x2=max(x)+2.0*dx;
z1=min(z)-dz; z2=max(z)+dz;

set(gca,'NextPlot','add','Box','on', ...
  'XLim', [x1 x2], ...
  'YDir','reverse', ...
  'YLim',[z1 z2]);

% 	fillcolor = [1 0 0];
% 	linecolor = [0 0 0];

	fillcolor = [1 0 0];
	linecolor = [0 0 0];


	linewidth = 0.1;

	z=z'; 	% input as row vector
	zstart=z(1);
	zend  =z(nz);

for i=1:nx
   
  if trmx(i) ~= 0    % skip the zero traces
	tr=a(:,i); 	% --- one scale for all section
  	s = sign(tr) ;
  	i1= find( s(1:nz-1) ~= s(2:nz) );	% zero crossing points
	npos = length(i1);


	%12/7/97 
	zadd = i1 + tr(i1) ./ (tr(i1) - tr(i1+1)); %locations with 0 amplitudes
	aadd = zeros(size(zadd));

	[zpos,vpos] = find(tr >0);
	[zz,iz] = sort([zpos; zadd]); 	% indices of zero point plus positives
	aa = [tr(zpos); aadd];
	aa = aa(iz);

	% be careful at the ends
		if tr(1)>0, 	a0=0; z0=1.00;
		else, 		a0=0; z0=zadd(1);
        end
		if tr(nz)>0, 	a1=0; z1=nz; 
		else, 		a1=0; z1=max(zadd);
        end
			
	zz = [z0; zz; z1; z0];
 	aa = [a0; aa; a1; a0];
		

	zzz = zstart + zz*dz -dz;

	patch( aa+x(i) , zzz,  fillcolor);

  line( 'Color',[1 1 1],'Xdata', x(i)+[0 0], 'Ydata',[zstart zend]); % remove zero line

%'LineWidth',linewidth, ...
%12/7/97 'Xdata', x(i)+[0 0], 'Ydata',[z0 z1]*dz);	% remove zero line

	line( 'Color',linecolor,  ...
	 'LineWidth',linewidth, ...
	 'Xdata', tr+x(i), 'Ydata',z);	% negatives line

   else % zeros trace
	line( 'Color',linecolor, ...
	 'LineWidth',linewidth, ...
         'Xdata', [x(i) x(i)], 'Ydata',[zstart zend]);
  end
end


function [newtraces]=normit(traces)

factors = max(abs(traces));

[m,n] = size(traces);
newtraces = zeros(size(traces));
parfor i = 1:n
	if factors(i) ~= 0
		newtraces(:,i) = traces(:,i)/factors(i);
	end
end

