% Загружаем общий файл с кривыми от профессора
file = 'D:\Рабочий стол\MastersThesis\CNR_DCs_uncleaned_Daulet.mat';
data = load(file);

% Смотрим, что именно внутри файла
whos('-file', file)   % <-- это покажет список переменных
curves = data.vr;   % заменишь на правильное имя, которое покажет whos

figure;
hold on;
for i = 1:length(curves)
    if isfield(curves(i), 'freqtot') && isfield(curves(i), 'stack_dc')
        if ~isempty(curves(i).freqtot) && ~isempty(curves(i).stack_dc)
            plot(curves(i).freqtot, curves(i).stack_dc, '-', 'LineWidth', 1);
        end
    end
end
xlabel('Frequency (Hz)')
ylabel('Velocity (m/s)')
title('All Dispersion Curves (Uncleaned)')
grid on;
hold off;
