% Путь к папке с результатами
folder = 'D:\Рабочий стол\MastersThesis\DC_interferometry';

% Получаем список всех файлов .mat
files = dir(fullfile(folder, '*.mat'));

figure;
hold on;

for i = 1:length(files)
    % Загружаем очередной файл
    data = load(fullfile(folder, files(i).name));
    
    % Проверяем наличие нужных переменных
    if isfield(data, 'stack_dc') && isfield(data, 'freqtot') ...
            && ~isempty(data.stack_dc) && ~isempty(data.freqtot)
        
        % Строим только точки (синие)
        h = plot(data.freqtot, data.stack_dc, '.', ...
                 'Color', [0 0.4470 0.7410], ... % MATLAB blue
                 'MarkerSize', 5);
        
        % Имя файла записываем в UserData (для datacursor)
        h.UserData = files(i).name;
    else
        fprintf('Пропускаю файл: %s (нет stack_dc или freqtot)\n', files(i).name);
    end
end

xlabel('Frequency (Hz)')
ylabel('Phase Velocity (m/s)')
title('All Dispersion Curves (Blue Points)')
grid on;
hold off;

% Включаем datacursormode
dcm = datacursormode(gcf);
set(dcm,'UpdateFcn',@myUpdateFcn);

% Функция для кастомного текста курсора
function txt = myUpdateFcn(~,event_obj)
    pos = event_obj.Position;
    h = get(event_obj,'Target');
    filename = h.UserData; % имя файла
    txt = {['X: ', num2str(pos(1))], ...
           ['Y: ', num2str(pos(2))], ...
           ['File: ', filename]};
end
