function [veltemp] = onepointpick(dispimage,freq,vel,f0,v0)
% ONEPOINTPICK This function picks the dispersion curve from a dispersion
% image based on one reference point.
% 
% % INPUT:
%   dispimage: The dispersion image matrix.
%        freq: The corresponded frequency vector of the dispersion image.
%         vel: The corresponded velocity vector of the dispersion image.
%          f0: The frequency of the reference point.
%          v0: The velocity of the reference point.
%
% % OUTPUT:
%    freqtemp: The frequency of the picked dispersion curve.
%     veltemp: The velocity of the picked dispersion curve.
%
global stazioni2
% Some parameters.
[nv,nf] = size(dispimage);

% Initialize
% freqtemp = zeros(nf,1);
veltemp = zeros(nf,1);

% Get the the index of this point.
[~,If0] = min(abs(freq - f0));
[~,Iv0] = min(abs(vel - v0));

% 1st find out the dispersion curve near the reference point.
disp = dispimage(:,If0);

findit = 0;
if (disp(Iv0) > disp(Iv0-1) && disp(Iv0) > disp(Iv0 + 1))
    Ifind = Iv0;
    findit = 1;
end

% Loop to find out the local maximum.
Ivu = Iv0;
Ivd = Iv0;
while findit == 0
    
    % Check the index is in the boundary.
    check = 0;
    
    Ivu = Ivu + 1;
    if Ivu < nv
        if (disp(Ivu) > disp(Ivu-1) && disp(Ivu) > disp(Ivu + 1))
            Ifind = Ivu;
            break;
        end
        check = check + 1;
    end
    
    Ivd = Ivd - 1;
    if Ivd > 1
        if (disp(Ivd) > disp(Ivd-1) && disp(Ivd) > disp(Ivd + 1))
            Ifind = Ivd;
            break;
        end
        check = check + 1;
    end
    
    % Out of the boundary, stop the loop.
    if check ==0
        % Take the reference point as the local maximum.
        Ifind = Iv0;
        break;
    end
    
end

% freqtemp(If0) = freq(If0);
veltemp(If0) = vel(Ifind);

% left part
for ip = If0 - 1:-1:1
    
    v1 = veltemp(ip+1);
    % get the the index of this point.
    [~,Iv1] = min(abs(vel - v1));
    
    disp = dispimage(:,ip);
    findit = 0;
    if (disp(Iv1) > disp(Iv1-1) && disp(Iv1) > disp(Iv1 + 1))
        Ifind = Iv1;
        findit = 1;
    end
    
    Ivu = Iv1;
    Ivd = Iv1;
    while findit == 0
        check = 0;
        
        Ivu = Ivu + 1;
        if Ivu < nv
            if (disp(Ivu) > disp(Ivu-1) && disp(Ivu) > disp(Ivu + 1))
                Ifind = Ivu;
                break;
            end
            check = check + 1;
        end

        Ivd = Ivd - 1;
        if Ivd > 1
            if (disp(Ivd) > disp(Ivd-1) && disp(Ivd) > disp(Ivd + 1))
                Ifind = Ivd;
                break;
            end
            check = check + 1;
        end
        
        if check ==0
            Ifind = Iv1;
            break;
        end
    end
    
%     freqtemp(ip) = freq(ip);
    veltemp(ip) = vel(Ifind);
    
end

% right part
for ip = If0 + 1:nf
    
    v0 = veltemp(ip - 1);
    % get the the index of this point.
    [~,Iv1] = min(abs(vel - v0));
    
    disp = dispimage(:,ip);
    findit = 0;
    if (disp(Iv1) > disp(Iv1-1) && disp(Iv1) > disp(Iv1 + 1))
        Ifind = Iv1;
        findit = 1;
    end
    
    Ivu = Iv1;
    Ivd = Iv1;
    while findit == 0
        check = 0;
        Ivu = Ivu + 1;
        if Ivu < nv
            if (disp(Ivu) > disp(Ivu-1) && disp(Ivu) > disp(Ivu + 1))
                Ifind = Ivu;
                break;
            end
            check = check + 1;
        end

        Ivd = Ivd - 1;
        if Ivd > 1
            if (disp(Ivd) > disp(Ivd-1) && disp(Ivd) > disp(Ivd + 1))
                Ifind = Ivd;
                break;
            end
            check = check + 1;
        end
        if check ==0
            Ifind = Iv1;
            break;
        end
    end
    
%     freqtemp(ip) = freq(ip);
    veltemp(ip) = vel(Ifind);
    
end

end

