function [x,y]=cleanDC(x,y,stackdisp)
% function (x,y)=cleaning(x,y)	-	remove selected points from a curve
% points to be deleted must be windowed on the graph
% by picking with the mouse two opposite corners of a rectangular window

% October 2000
% Sebastiano Foti
global macro
subplot(1,1,1)

hold on
imagesc(macro.freq, macro.vel,stackdisp)
axis xy
axis tight
colorbar
plot(macro.dc_ref(:,1),macro.dc_ref(:,2),'g.')
plot(x,y,'b.');
xlabel('Frequency (Hz)')
ylabel('Velocity (m/s)')
legend('dispersion curve');
title('select the points to be erased using a window','fontsize',12)

[x1,y1]=ginput(1);
[x2,y2]=ginput(1);
index1=find(x>=min(x1,x2)&x<=max(x1,x2));
index2=index1(find(y(index1)>=min(y1,y2)&y(index1)<=max(y1,y2)));

x(index2)=[];
y(index2)=[];

% veltot(index2,:)=[];


hold on
plot(x,y,'r.');

