%questa funzione inizializza l'intero processo

close all
clear
clc
d=pwd;

%The global variable
global macro

% %loading geometry and sampling rate
load pairs_Kefalonia
load pairs360_Kefalonia
load REC_Kefalonia
load window_info_Kefalonia

% Single reliable multi-channel DC. see next comment for format
load('refmean_Kefalonia.mat')
macro.dc_ref=dc_ref;
% Reference curve2  contains two variables, dc_ref that contains many
% multichannel dcs with usual format, column 1 as the index, column 2 freqs
% and column 3 the velocity. The file also contains a variable called
% ref_coord that contains the coordinates of the reference DCs, each row
% matches the index.
load('refcurve_Kefalonia.mat')

% The hyper parameters of the two-station method.
% % % nt: number of samples for each trace
% % % SR: sampling rate
% % % Wavelength limit: The sampling wavelength limit according to inter reveiver offset.
% % % % % Usuaklly twice the offset is reasonable and mathematically can be proven
% % % sigmaL: defines the width of the frequency filter used to decompose
% % % % % traces.
% % % freq: vector of desired frequency for DCs
% % % vel: velocity range for the cross correlation matrix
% % % angle_threshold: the deviation from source azimuth
prompt = {'nt','SR','Wavelength_limit (times dx)','sigma','freq','vel','angle_threshold', 'stack_lim','max inter-station offset'};
dlg_title = 'Parameters';
num_lines = 1;
def = {'2500','0.002','2','0.15','2:0.5:30','50:1:1400','2','5','80'};
answer = inputdlg(prompt,dlg_title,num_lines,def);

macro.nt=[str2num(answer{1,1})];
macro.dt=[str2num(answer{2,1})];
macro.times=str2num(answer{3,1});
macro.sigma=str2num(answer{4,1});
macro.freq=str2num(answer{5,1});
macro.vel=str2num(answer{6,1});
thresh=str2num(answer{7,1});
stack_lim = str2num(answer{8,1});
max_off = str2num(answer{9,1});
macro.shotpath="C:\Users\User\Dropbox (Politecnico Di Torino Studenti)\Kefalonia Project\Data\two-station_passive\passive afterbeam";
save_path='C:\Users\User\Dropbox (Politecnico Di Torino Studenti)\Kefalonia Project\Data\two-station_passive\passive_dcs';
% Storing the hyper parameters and external info to global variable macro which will be used in Picking function.
macro.t = 0:macro.dt:(macro.nt-1)*macro.dt;
macro.fband=[min(macro.dc_ref(:,1)) max(macro.dc_ref(:,1))];
[~,macro.f_ind]=find((macro.freq(1,:)>=macro.fband(1) & macro.freq(1,:)<=macro.fband(2)));
nparis=length(pairs);
% Define the spectrum info
macro.nfreq = length(macro.freq);    % Number of frequencies
macro.nvel = length(macro.vel);    
% Number of velocities
%

%% Loop over receiver pairs. For Kefalonia, we have 3570 pairs.
for ipairs = 1:length(pairs)

    ipairs
    macro.ipairs=ipairs;
    % The trace number and coordinates of the current two receivers.
    macro.trace_num1 = pairs(ipairs,1);
    macro.trace_num2 = pairs(ipairs,2);
    coordinates=[REC(pairs(ipairs,1),:); REC(pairs(ipairs,2),:)] ;
    % inter receiver offset of the current receiver pair
    dx = pairs(ipairs,3);
    macro.dx=dx;
    %%
    % % Possible shots. We need a matrix, first column number of shots.
    % second azimuth.
    azi=pairs(ipairs,4);
    abs_shot_azi=window_az(:,1);
    f=find(abs_shot_azi>180);
    abs_shot_azi(f,1)=abs_shot_azi(f,1)-180;
    f=find (abs_shot_azi<(azi+thresh) & abs_shot_azi>(azi-thresh));
    if ~isempty(f)
        macro.shot_az= (window_az(f,1));
        macro.shot_nr=length(f);
        for k=1:length(f)
            shot_fnames{k,1} = window_fname{f(k),1};
        end
        macro.shot_fname = shot_fnames;
        clear shot_fnames
        macro.pair=pairs(ipairs,:);
        cent_x=mean(REC(pairs(ipairs,1:2),1));
        cent_y=mean(REC(pairs(ipairs,1:2),2));
        cent_coord=[cent_x cent_y];
        %compute Euclidean distances:
        distances = sqrt(sum(bsxfun(@minus, cent_coord, ref_coord).^2,2));
        [aa,bb]=sort(distances);
        ff=find(dc_ref(:,1)==bb(1));
        macro.dc_ref1=dc_ref(ff,:);
        ff=find(dc_ref(:,1)==bb(2));
        macro.dc_ref2=dc_ref(ff,:);
        if macro.shot_nr>=stack_lim & dx<max_off
            macro.REC=REC(pairs(ipairs,1:2),:);
            macro.pairs360_az=pairs_360(ipairs,4);
            [stackdisp,stack_dc,freqtot,veltot,disp]= Picking_test;
        else
            stack_dc=NaN;
        end

        if ~isnan(stack_dc) 
            save([save_path '\'...
                num2str(pairs(ipairs,1)) '_r2_' num2str(pairs(ipairs,2)) '_ns_' num2str(macro.shot_nr) '.mat']...
                ,'stack_dc','freqtot','dx','stackdisp','coordinates','veltot','disp');
        end
    end

end
