% === Load Receiver Coordinates ===
coordFile = 'D:\Рабочий стол\MastersThesis\receivers.xlsx';
T = readtable(coordFile, 'Sheet', 'Sheet 1 - latlon_to_utm', ...
              'ReadVariableNames', false);
T = T(2:end,:);  % drop in-sheet header row
T.Properties.VariableNames = {'Name','X','Y'};
X = str2double(T.X);
Y = str2double(T.Y);

% --- Plot Receivers ---
figure;
hold on; axis equal; grid on;
xlabel('X (UTM)'); ylabel('Y (UTM)');
title('Receiver Paths');

% --- Plot ALL paths with thin transparent green lines ---
N = length(X);
for i = 1:N
    for j = i+1:N
        plot([X(i), X(j)], [Y(i), Y(j)], '-', ...
            'Color', [0 1 0 0.25], ...  % green with 5% opacity
            'LineWidth', 0.3);          % very thin lines
    end
end


% --- Plot Receivers on top ---
scatter(X, Y, 5, 'b', 'filled');  % slightly larger dots

legend('All Receiver Paths','Receivers','Location','best');

% --- Force legend definitions ---
% (draw invisible objects for legend entries with solid colors)
hold on;
hPathDef = plot(nan, nan, '-', 'Color', [0 0.6 0], 'LineWidth', 1.5);
hRecDef  = scatter(nan, nan, 30, 'b', 'filled');

legend([hPathDef, hRecDef], {'Receiver Paths','Receivers'}, 'Location','best');
