function [stackdisp,stack_dc,freqtot,veltot,disp]=Picking
%This function, loads the to traces for the possible shots and calls FTAN
%to compute the individual cross-correlation matrices (spect). It calls Autopick to
%pick the individual DC (veltot) from each spectrum. The spectra are stacked (stack_spect) and
%then Autopick pickes the stack_dc.

global macro
% offset_mat=macro.offset_mat;
%launching for loop over the pairs
trace_num1=macro.trace_num1;
trace_num2=macro.trace_num2;
dx=macro.dx
t=macro.t;
freq=macro.freq;
vel=macro.vel;
sigma=macro.sigma;

disp=zeros(length(vel),length(freq),macro.shot_nr);
shotpath=macro.shotpath;
shot_fname=macro.shot_fname;
shot_nr=macro.shot_nr;

for i = 1:shot_nr

    tr=load(strcat(shotpath,'\', shot_fname{i}),'traces');
    traces=tr.traces;

    trace1 = traces(:,trace_num1);
    trace1=trace1-mean((trace1));
    trace2 = traces(:,trace_num2);
    trace2=trace2-mean((trace2));




    if abs(macro.shot_az(i)-macro.pairs360_az)>10
        temp=trace1;
        trace1=trace2;
        trace2=temp;
        %         figure
        %         plot(macro.REC(2,1),macro.REC(2,2),'*k')
        %         hold on
        %         plot(macro.REC(1,1),macro.REC(1,2),'*b')
        %         legend({'receiver 1',"receiver 2"})
        %         title(num2str(macro.shot_az (i)))
        %         axis equal
        %         abs(macro.shot_az-macro.pairs360_az);
        %         hold on
        %         plot(macro.dc_ref1(:,5),macro.dc_ref1(:,6),'.r')
        %         plot(macro.dc_ref2(:,5),macro.dc_ref2(:,6),'.r')

        %     else
        %         figure
        %         plot(macro.REC(1,1),macro.REC(1,2),'*k')
        %         hold on
        %         plot(macro.REC(2,1),macro.REC(2,2),'*b')
        %         legend({'receiver 1',"receiver 2"})
        %         title(num2str(macro.shot_az (i)))
        %         axis equal
        %         abs(macro.shot_az-macro.pairs360_az);

    end

    m_trace1=mean(abs(trace1));
    m_trace2=mean(abs(trace2));
    if m_trace1>0 & m_trace2>0

        %         trace1_r=resample(trace1,5,1);
        %         trace2_r=resample(trace2,5,1);
        %         t_r=0:0.002/5:5-0.002/5;
        %         disp(:,:,i) = FTAN(trace1_r,trace2_r,dx,t_r,freq,vel,sigma);

        disp(:,:,i) = FTAN(trace1,trace2,dx,t,freq,vel,sigma);
    end

end

%% The picking from the cross-correlation matrix


stackdisp = sum(disp,3);
disp=disp(:,:,1:shot_nr);
close all
vlim=macro.times*macro.dx*macro.freq;
m_disp=mean(mean(abs(stackdisp)));

if ~isnan(stackdisp) & m_disp>0
    figure
    imagesc(macro.freq, macro.vel,stackdisp)
    axis xy
    axis tight
    xlabel('Frequency (Hz)')
    ylabel('Velocity (m/s)')
    colorbar
    for zz=1:size(stackdisp,2)
        stackdisp(:,zz) = stackdisp(:,zz)./max(abs(stackdisp(:,zz)));
    end
    %%%% test
    figure
    set(gcf,'units','points','position',[1600 0 1200 500])
    subplot(1,3,1)
    plot(linspace(0,500,length(trace1)),abs(fft(trace1)))
    set(gca, 'YScale', 'log')
    xlabel('Frequency')
    ylabel("amplitude")
    xlim([0 30])




    %%%% TEMPORARY
    subplot(1,3,2)
    imagesc(macro.freq, macro.vel,stackdisp)
    axis xy
    axis tight
    xlabel('Frequency (Hz)')
    ylabel('Velocity (m/s)')
    [~,peaky]= max(stackdisp);
    vel2=vel(peaky);
    T2=dx./vel2;

    for i=1:10
        T2(i+1,:)=T2(i,:)+1./freq;
    end
    T2(12,:)=T2(1,:);
    T2(1,:)=[];
    for i=11:50
        T2(i+1,:)=T2(i,:)-1./freq;
    end
    t_max=dx/50;
    t_min=dx/1400;
    f=find(T2<t_min | T2>t_max);
    T2(f)=NaN;
    hold on, plot(freq, dx./T2,'.k')
    hold on
    plot(freq,dx./T2(11,:),'.r')
    %%%%
    subplot(1,3,3)

    imagesc(macro.freq, macro.vel,stackdisp)
    hold on
    plot(macro.dc_ref(:,1),macro.dc_ref(:,2),'g*')
    hold on
    plot(macro.dc_ref1(:,2),macro.dc_ref1(:,3),'k.')
    hold on
    plot(macro.dc_ref2(:,2),macro.dc_ref2(:,3),'b.')
    plot(macro.freq,vlim)
    ylim([macro.vel(1) macro.vel(end)]);
    xlim([macro.freq(1) macro.freq(end)]);
    axis xy
    xlabel('Frequency (Hz)')
    ylabel('Velocity (m/s)')


    [stack_dc,veltot]=Pick(stackdisp,gcf,disp);
    freqtot=macro.freq';
    [Index] = (stack_dc(:,1)./freqtot > macro.dx*macro.times);
    freqtot(Index) = [];
    stack_dc(Index,:) = [];
    plot(freqtot,stack_dc,'-k')
    fr=freqtot';
    vr=stack_dc;
    info1 = menu('Clean?', 'Yes', 'No');

    while info1==1
        [fr,vr]=cleanDC(fr,vr,stackdisp);
        info1 = menu('Clean?', 'Yes', 'No');
    end
    info2 = menu('Save?', 'Yes', 'No');
    if info2==1
        [f ~]=find(fr==freqtot);
        freqtot = freqtot(f);
        stack_dc = stack_dc(f,:);
        veltot=veltot(f,:);
        plot(freqtot,stack_dc,'or')
        %         pause
        figure
        set(gcf,'units','points','position',[1600 0 1200 500])
        subplot(1,3,1)
        plot(linspace(0,500,length(trace1)),abs(fft(trace1)))
        set(gca, 'YScale', 'log')
        xlabel('Frequency')
        ylabel("amplitude")
        xlim([0 30])

        subplot(1,3,2)
        imagesc(macro.freq, macro.vel,stackdisp)
        axis xy
        axis tight
        xlabel('Frequency (Hz)')
        ylabel('Velocity (m/s)')
        hold on, plot(freq, dx./T2,'.k')
        hold on
        plot(freq,dx./T2(11,:),'.r')
        hold on
        plot(macro.dc_ref1(:,2),macro.dc_ref1(:,3),'g.')
        hold on
        plot(macro.dc_ref2(:,2),macro.dc_ref2(:,3),'b.')
        %%%%
        subplot(1,3,3)

        imagesc(macro.freq, macro.vel,stackdisp)
        hold on
        plot(freqtot,stack_dc,'or')
        %     plot(macro.dc_ref(:,1),macro.dc_ref(:,2),'g*')
        %     hold on
        %             plot(macro.dc_ref1(:,2),macro.dc_ref1(:,3),'g.')
        %     hold on
        %             plot(macro.dc_ref2(:,2),macro.dc_ref2(:,3),'b.')
        plot(macro.freq,vlim)
        ylim([macro.vel(1) macro.vel(end)]);
        xlim([macro.freq(1) macro.freq(end)]);
        axis xy
        xlabel('Frequency (Hz)')
        ylabel('Velocity (m/s)')


    else
        stack_dc=NaN;
        freqtot=NaN;
    end
else
    stack_dc=NaN;
    freqtot=NaN;
    stackdisp=NaN;
    veltot=NaN;
end




