function [stackdisp,stack_dc,freqtot]=Picking2
%This function, loads the to traces for the possible shots and calls FTAN
%to compute the individual cross-correlation matrices (spect). It calls Autopick to
%pick the individual DC (veltot) from each spectrum. The spectra are stacked (stack_spect) and
%then Autopick pickes the stack_dc.

global macro
shot_num=macro.shot_num;
ipairs=macro.ipairs;
pair=macro.pair;
disp = zeros(macro.nvel,macro.nfreq,length(shot_num));
stackdisp=[];
offset_mat=macro.offset_mat;
%launching for loop over the pairs
kk=0;
for ishot = shot_num
    macro.ishot=ishot;
    % Load data.
    load(['C:\Users\User\OneDrive - Politecnico di Torino\Master STUDENTS\Mohammad\two-station_with_stacking\Geometry\' num2str(ishot) '.mat']);
    % Make sure the 1st receiver has a smaller offset.
    traces=Data;
    offset1=offset_mat(ishot,pair(:,1));
    offset2=offset_mat(ishot,pair(:,2));
    if offset1*offset2>0
        if abs(offset1) < abs(offset2)
            trace1 = traces(:,macro.trace_num1);
            trace2 = traces(:,macro.trace_num2);
        else
            trace2 = traces(:,macro.trace_num1);
            trace1 = traces(:,macro.trace_num2);
        end
        
        disp(:,:,ishot) = FTAN(trace1,trace2,macro.dx,macro.t,macro.freq,macro.vel,macro.sigma);
    end
end
stackdisp = sum(disp,3);

close all
vlim=macro.times*macro.dx*macro.freq;

if ~isnan(stackdisp)
    figure
    imagesc(macro.freq, macro.vel,stackdisp)
    axis xy
    axis tight
    xlabel('Frequency (Hz)')
    ylabel('Velocity (m/s)')
    colorbar
    for zz=1:size(stackdisp,2)
        stackdisp(:,zz) = stackdisp(:,zz)./max(abs(stackdisp(:,zz)));
    end
    
    figure
    hold on
    imagesc(macro.freq, macro.vel,stackdisp)
    plot(macro.dc_ref(:,1),macro.dc_ref(:,2),'g*')
    plot(macro.freq,vlim)
    ylim([macro.vel(1) macro.vel(end)]);
    xlim([macro.freq(1) macro.freq(end)]);
    axis xy
    xlabel('Frequency (Hz)')
    ylabel('Velocity (m/s)')
    colorbar
    
    [stack_dc]=Pick(stackdisp,gcf);
    freqtot=macro.freq';
    [Index] = (stack_dc(:,1)./freqtot > macro.dx*macro.times);
    freqtot(Index) = [];
    stack_dc(Index,:) = [];
    plot(freqtot,stack_dc,'-k')
    fr=freqtot';
    vr=stack_dc;
    info1 = menu('Clean?', 'Yes', 'No');
    while info1==1
        [fr,vr]=cleanDC(fr,vr,stackdisp);
        info1 = menu('Clean?', 'Yes', 'No');
    end
    info2 = menu('Save?', 'Yes', 'No');
    if info2==1
        [f ~]=find(fr==freqtot);
        freqtot = freqtot(f);
        stack_dc = stack_dc(f,:);
        plot(freqtot,stack_dc,'or')
        pause
    else
        stack_dc=NaN;
        freqtot=NaN;
    end
else
    stack_dc=NaN;
    freqtot=NaN;
    stackdisp=NaN;
end




