function [dc,dc_ind] = Pick(disp,fig,disp_ind)
% This function picks the DC, as the spectal maximum of the cross
% multiplication matrix "disp", closest to the reference DC.
% For each frequency inside the frequency band of the reference Dc,
% it finds the velocity local peaks, pickes a curve with them modal
% follower
% and computes the distance of all these curves from the reference
% and saves their velocity peak and frequency. This process is repeated for all
% frequencies inside the frequency band, and the DC with the smallest distance
% provides the frequency and velocity from which we pick the final DC with
% the modal follower

global macro

[f0,v0] = ginput(1);
dc = onepointpick(disp,macro.freq,macro.vel,f0,v0);
for i=1:size(disp_ind,3)
    temp=disp_ind(:,:,i);
    dc_ind(:,i) = onepointpick(temp,macro.freq,macro.vel,f0,v0);
end

end
