%% Receiver footprint: black bounding box + shaded receiver area
data = readtable('D:\Рабочий стол\MastersThesis\receivers.xlsx', ...
                 'Sheet','Sheet 1 - latlon_to_utm');
data = data(2:end,:);
data.Properties.VariableNames = {'Name','X','Y'};
X = str2double(data.X);
Y = str2double(data.Y);

figure('Color','w'); hold on;

% --- Ресиверы ---
scatter(X, Y, 28, 'k', 'filled', 'Marker', 'v');

% --- Выпуклая оболочка (область ресиверов) ---
idx = convhull(X, Y);
patch('XData', X(idx), 'YData', Y(idx), ...
      'FaceColor', [0.3 0.5 1], 'FaceAlpha', 0.08, ...
      'EdgeColor', [0.3 0.5 1], 'LineStyle', '--', 'LineWidth', 1.2);

% --- Внешний bounding box (черный квадрат) ---
xMin = min(X); xMax = max(X);
yMin = min(Y); yMax = max(Y);
W = xMax - xMin;
H = yMax - yMin;
cx = (xMin + xMax)/2;
cy = (yMin + yMax)/2;

rectangle('Position', [xMin, yMin, W, H], ...
          'EdgeColor', [0 0 0], 'LineStyle', '--', 'LineWidth', 1.3);

% --- Подписи длины и ширины (черным цветом) ---
text(cx, yMin - 0.06*H, sprintf('Width = %.2f m', W), ...
     'HorizontalAlignment','center','VerticalAlignment','top', ...
     'FontWeight','bold','Color','k');
text(xMin - 0.06*W, cy, sprintf('Length = %.2f m', H), ...
     'Rotation',90,'HorizontalAlignment','center','VerticalAlignment','middle', ...
     'FontWeight','bold','Color','k');

% --- Центральный квадрат 5×5 м (песчаное тело) ---
nbins = 60;
[Ny,ey] = histcounts(Y, nbins); [~,iy] = max(Ny);
y0 = median(Y(Y>=ey(iy) & Y<ey(iy+1)));
[Nx,ex] = histcounts(X, nbins); [~,ix] = max(Nx);
x0 = median(X(X>=ex(ix) & X<ex(ix+1)));
halfSide = 2.5; dx_shift = -1.2;
rectangle('Position',[x0-halfSide+dx_shift, y0-halfSide, 2*halfSide, 2*halfSide], ...
          'EdgeColor',[0.2 0.2 0.2], 'LineStyle','--', 'LineWidth',1.2);

% --- Подписи "5 m" ---
text(x0 - halfSide - 0.6 + dx_shift, y0, '5 m', 'Rotation',90, ...
     'HorizontalAlignment','center','VerticalAlignment','middle','FontWeight','bold');
text(x0 + dx_shift, y0 - halfSide - 0.6, '5 m', ...
     'HorizontalAlignment','center','VerticalAlignment','top','FontWeight','bold');

axis equal; axis off; box off; hold off;
