% --- Загрузка ресиверов ---
data = readtable('D:\Рабочий стол\MastersThesis\receivers.xlsx', ...
                 'Sheet', 'Sheet 1 - latlon_to_utm');
data = data(2:end,:); % убираем строку с заголовками внутри Excel
data.Properties.VariableNames = {'Name','X','Y'};

X = str2double(data.X);
Y = str2double(data.Y);

% --- Построение карты ---
figure;
hold on; axis equal; grid on;

% Синие точки - все ресиверы
scatter(X, Y, 8, 'b', 'filled');

% Пути из .mat файлов
pathFolder = 'D:\Рабочий стол\MastersThesis\DC_interferometry';
files = dir(fullfile(pathFolder, '*.mat'));

for i = 1:length(files)
    d = load(fullfile(pathFolder, files(i).name));
    if isfield(d,'coordinates')
        x1 = d.coordinates(1);
        y1 = d.coordinates(2);
        x2 = d.coordinates(3);
        y2 = d.coordinates(4);

        % Линия между ресиверами (тонкая, полупрозрачная зелёная)
        plot([x1 x2],[y1 y2],'Color',[0 1 0 0.25],'LineWidth',0.3);
    end
end

xlabel('X (UTM)');
ylabel('Y (UTM)');
title('Receiver Paths');

% --- Легенда (яркая и толстая для наглядности) ---
hPathDef = plot(nan, nan, '-', 'Color', [0 0.8 0], 'LineWidth', 2.5);
hRecDef  = scatter(nan, nan, 30, 'b', 'filled');
legend([hRecDef, hPathDef], {'Receivers','Receiver Paths'}, 'Location','best');
