% this function implements a Gaussian band pass filter

%INPUT: traccia: column vector with the trace to be filtered
%SR: sampling rate of the trace, in ms
%f0: central frequency of the bandpass Hz
%larghezza: width of the bandpass filter, expressed as the ratio between
%standard deviation and f0
%flag. If flag is there and is 1, graphic output are displayed

%output: tracciafilt: filterd trace, column vector
%f: row vector of frequencies for the filter response
%rapporto= row vector, true frequency response of filter
%ideale= row vector, ideal frequency response of filter
%tracciaquad=trace in quadrature with filtered trace

function [tracciafilt,f,rapporto,ideale,tracciafiltquad]=FiltroGaussiano(traccia,SR,f0,larghezza,flag)

NFFT=nextpow2(length(traccia));
NFFT=2^(NFFT);
Fs=1/SR;
f= (Fs/2)*linspace(0,1,NFFT/2+1);
spettro=fft(traccia,NFFT)/length(traccia);

omegas=f*2*pi;
omega0=f0*2*pi;

filtro=exp(-.5.*((omegas-omega0)./(omega0*larghezza)).^2);

ampiezza=2*abs(spettro(1:(NFFT/2)+1));
fase=angle(spettro(1:(NFFT/2)+1));
ampiezza=ampiezza.*filtro';

tempi=SR*(0:length(traccia)-1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%inverse Fourier Transform: method 1
% tic
tracciafilt=zeros(size(traccia));

for j=1:length(ampiezza);
    tracciafilt=tracciafilt+(ampiezza(j)*cos((2*pi*f(j)*tempi)+fase(j)))';
end
tracciafilt=tracciafilt*(length(tracciafilt)/NFFT);
if nargout>4
    tracciafiltquad=-imag(hilbert(tracciafilt));
end
%  toc

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % %inverse Fourier Transform: method 2 (requires a greter memory, but
% % faster)
% 
% ampiezza=ampiezza';
% [tempi2,fase2]=meshgrid(tempi,fase);
% [~,f2]=meshgrid(tempi,f');
% tracciafilt=ampiezza*cos((2*pi.*tempi2.*f2)+fase2);
% tracciafilt=tracciafilt*(length(tracciafilt)/NFFT);
% tracciafilt=tracciafilt';
% 
% if nargout>4
%     tracciafiltquad=-imag(hilbert(tracciafilt));
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% % % inverse Fourier Transform: method 3 (like method 2, but stepwise)
% % tic
% ampiezza=ampiezza';
% n_iterazioni=ceil(length(traccia)/4000);
% tracciafilt=(zeros(size(traccia)))';
% 
%  for i=1:n_iterazioni
%     %selecting portion of tempi
%     minimo=(((i-1)*4000)+1);
%     massimo=min([i*4000,length(tempi)]);
%     tempi_temp=tempi(minimo:massimo);
%     [tempi2,fase2]=meshgrid(tempi_temp,fase);
%     [~,f2]=meshgrid(tempi_temp,f');
%     tracciafilt(minimo:massimo)=ampiezza*cos((2*pi.*tempi2.*f2)+fase2);
% end
% tracciafilt=tracciafilt*(length(tracciafilt)/NFFT);
% tracciafilt=tracciafilt';
% if nargout>4
%     tracciafiltquad=-imag(hilbert(tracciafilt));
% end
% % toc
% % % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





spettrofilt=fft(tracciafilt,NFFT)/length(tracciafilt);
ampiezzafilt=2*abs(spettrofilt(1:(NFFT/2)+1));
rapporto=ampiezzafilt./(2*abs(spettro(1:(NFFT/2)+1)));
ideale=filtro;

if nargin>4
    if flag==1
        
        figure
        subplot(211)
        plot(tempi,traccia),grid on, box on
        xlabel('Time (s)'), title('Original trace')
        subplot(212),hold on
        plot(tempi,tracciafilt,'r'),grid on, box on
        if nargout>4
            plot(tempi,tracciafiltquad,'m')
            envelope=(tracciafilt.^2+tracciafiltquad.^2).^.5;
            plot(tempi,envelope,'k');
        end
        xlabel('Time (s)'), title('Filtered trace')
        saveas(gcf,'FiltroGaussiano_1.fig'),saveas(gcf,'FiltroGaussiano_1.tif')
        
        figure,hold on
        plot(f,log10(2*abs(spettro(1:(NFFT/2)+1))))
        plot(f,log10(2*abs(spettrofilt(1:(NFFT/2)+1))),'r')
        grid on, box on
        xlabel('Frequency (Hz)'),ylabel('log10(A)')
        legend('Original trace spectrum','Filtered trace spectrum')
        title('Amplitude spectra')
        assi=axis;
        axis([0 150 assi(3:4)]);
        saveas(gcf,'FiltroGaussiano_2.fig'),saveas(gcf,'FiltroGaussiano_2.tif')
        
        figure,hold on
        plot(f,ideale)
        plot(f,rapporto,'r'),grid on, box on
        xlabel('Frequency (Hz)')
        legend('Ideal filter','Actual filter');
        title('Filter frequency response')
        
        assi=axis;
        axis([0 150 assi(3:4)]);
        saveas(gcf,'FiltroGaussiano_3.fig'),saveas(gcf,'FiltroGaussiano_3.tif')
    end
end

        
        



