function [disp] = FTAN(trace1,trace2,dx,t,freq,vel,sigma)
% FTAN calculates the dispersion spectrum between two traces by using the 
% frequency-time analysis technique.
%
% % INPUT :
%   trace1: Waveform signal of the first trace.
%   trace2: Waveform signal of the second trace.
%       dx: Separation of two receivers.
%        t: Time vector.
%     freq: Frequency vector.
%      vel: Velocity vector.
%    sigma: Standar deviation used in Gaussian filter.
%
% % OUTPUT:
%     disp: Dispersion spectrum.
%

% Sampling rate
dt = t(2) - t(1);
nt = length(t);
nfreq = length(freq);

% Check the miminum and maximum velocity
minsamples = round(.05*nt);
minvel = round(max(min(vel),dx/(dt*(nt-minsamples))));
maxvel = round(min(max(vel),dx/dt));

% Initialize crosscorrelation matrix
t_lags = floor((dx/maxvel)/dt):round((dx/minvel)/dt);
nt_lags = length(t_lags);
timemat = zeros(nt_lags,nfreq);
% load dc_filt
% Loop over frequency
for ifreq = 1:nfreq
    % Multiple filtering (using a Gaussian window) for damping higher
    % modes. not applicable to passive.
        
%     t_filt1=offset1./dc_filt(:,2);
%     samp_filt1=round(t_filt1/0.002);
%     t_filt2=offset2./dc_filt(:,2);
%     samp_filt2=round(t_filt2./0.002);
%     t1=trace1;
%     t2=trace2;
%     wind1=gausswin(samp_filt1(ifreq)*2+1,20);
%     wind2=gausswin(samp_filt2(ifreq)*2+1,20);
%     win1=ones(length(t1),1);
%     win2=win1;
%     win1(1:samp_filt1(ifreq)+1)=wind1(1:samp_filt1(ifreq)+1);
%     win2(1:samp_filt2(ifreq)+1)=wind2(1:samp_filt2(ifreq)+1);
%     t1=t1.*win1;
%     t2=t2.*win2;
%     trace11=t1;
%     trace22=t2;
    
	trace_filt1 = multiple_filter(trace1,t,freq(ifreq),sigma);
    trace_filt2 = multiple_filter(trace2,t,freq(ifreq),sigma);
    
    % Do cross-correlation in time domain
    for ilag = 1:nt_lags
        timemat(ilag,ifreq) = sum(trace_filt1(1:end-t_lags(ilag)+1).*trace_filt2(t_lags(ilag):end));
    end
end

% The possible recorded velocity
record_vel = dx./(t_lags.*dt);

% Convert the cross-correlation matrix from time-based to velocity-based by
% using the 1D interpolation
for j=1:size(timemat,2)
disp(:,j) = interp1(record_vel,timemat(:,j),vel,'spline',0);
end
% Normalize the output matrix over each frequency
% disp = disp./max(abs(disp));


end







