%% Azimuth rose for 2130 selected pairs (0–180°, Rmax=200)
clear; close all; clc

data_dir = 'D:\Рабочий стол\MastersThesis\DC_interferometry';
S = dir(fullfile(data_dir,'*_r2_*.mat'));

azimuths = [];
max_selected = 2130;

for k = 1:numel(S)
    T = load(fullfile(S(k).folder, S(k).name));

    % Проверка, что пара "валидна"
    if ~isfield(T,'stack_dc') || ~isfield(T,'freqtot'), continue; end
    f = T.freqtot(:);  c = T.stack_dc(:);
    ok = isfinite(f) & isfinite(c) & f>0 & c>0;
    if nnz(ok) < 3, continue; end

    % Проверка координат
    if ~isfield(T,'coordinates') || numel(T.coordinates) < 4, continue; end
    xy = T.coordinates(:).';
    x1 = xy(1); y1 = xy(2); x2 = xy(3); y2 = xy(4);

    % Азимут (clockwise from North)
    dX = x2 - x1;
    dY = y2 - y1;
    az = atan2d(dX, dY);
    if az < 0, az = az + 360; end
    if az > 180, az = az - 180; end

    azimuths(end+1,1) = az; %#ok<SAGROW>
    if numel(azimuths) >= max_selected
        break
    end
end

fprintf('Used %d selected pairs for azimuth rose.\n', numel(azimuths));

%% === Rose Plot (0–180°, reduced radius) ===
figure('Color','w');
h = polarhistogram(deg2rad(azimuths), 18, ...
    'FaceColor',[0.2 0.4 1], 'EdgeColor','k', 'FaceAlpha',0.6);
title(sprintf('Azimuth Rose Diagram (0–180°) — %d selected pairs', numel(azimuths)), ...
      'FontWeight','bold');

ax = gca;
ax.ThetaLim = [0 180];
ax.RLim = [0 200];

% Полукруги на 50, 100, 150, 200
hold on;
path_levels = [50 100 150 200];
for k = 1:numel(path_levels)
    theta = linspace(0, pi, 400);
    rho = ones(size(theta)) * path_levels(k);
    polarplot(theta, rho, '--', 'Color', [0.4 0.4 0.4], 'LineWidth', 0.7);

    % Подписи сверху (90°)
    text(pi/2, path_levels(k) + 5, sprintf('%d', path_levels(k)), ...
        'HorizontalAlignment','center','VerticalAlignment','bottom', ...
        'FontSize',8,'Color',[0.25 0.25 0.25]);
end

% Подпись снизу
text(pi/2, -20, 'Number of paths', ...
    'HorizontalAlignment','center','VerticalAlignment','top', ...
    'FontWeight','bold','FontSize',9,'Color','k');
hold off;
