clc;
clear all;
close all;
global G M_moon R_moon r_rif v_rif m_rif t_rif a_rif T_rif;
G = 6.67e-11;   % m^3/kg/s^2 costante gravitazione universale
M_moon = 7.342e22; % kg massa luna
R_moon = 1737400;  % m raggio luna
r_rif = 15000;     % m distanza di riferimento
v_rif = 1000;       % m/s velocità di riferimento
m_rif = 1600;      % kg massa di riferimento
t_rif = r_rif / v_rif; % s tempo di riferimento
a_rif = v_rif^2./ r_rif; % accelerazione di riferimento
T_rif = m_rif*a_rif; % Spinta di riferimento

y0 = [15000+R_moon; 0; 0; 0;0;1692.3; 1589.07]; 
y0_adim = y0 ./ [r_rif; r_rif; r_rif; v_rif; v_rif; v_rif; m_rif]; 
problems.x0 = y0_adim; 

problems.nodes1 = 100; 
problems.nodes2 = 10; 
problems.nodestot = problems.nodes1 + problems.nodes2;

problems.LBtau1 = 30;           
problems.UBtau1 = 40;          
problems.LBangolo1 = [pi/2]; 
problems.UBangolo1 = [3*pi/2];   
problems.LBspinta = [4600] / T_rif;   
problems.UBspinta = [4600] / T_rif;  

problems.StimaAngoloT1 = linspace(3.2, 2.5, problems.nodes1)'; 
problems.StimaT = linspace(4600, 4600, problems.nodes1)' / T_rif; 
problems.tau1 = 35; % 450 secondi

solution = risolvi(problems);
fprintf('La massa finale è: %.2f kg\n', solution.state(end, 7) * m_rif);
fprintf('Il tempo di discesa è: %.2f s\n', solution.tf1_tf2(1)*t_rif)
fprintf('Il tempo di touchdown è: %.2f s\n', solution.tf1_tf2(2)*t_rif)



%%
figure(1);  
clf;
hold on
plot(solution.time, solution.state(:, 4).*v_rif, 'o');
xline(solution.tf1_tf2(1),'--r',{'Fine Fase 1'});
hold off;
grid on;
xlabel('Tempo Adimensionale [/]');
ylabel('Velocità radiale [m/s]');
title('Velocità radiale (Vr) nel tempo');

figure(2); 
plot(solution.state(:, 2), solution.state(:, 1), 'o');
grid on;
xlabel('Latitudine delta [rad]');
ylabel('Raggio adimensionale r [/]');
title('Discesa da h_0=15km (Vista Latitudinale)');
yline(R_moon/r_rif,'--r',{'Superficie Lunare'});

figure(3);
plot(solution.state(:, 3), solution.state(:, 1), 'o');
grid on;
xlabel('Longitudine theta [rad]');
ylabel('Raggio adimensionale r [/]');
title('Discesa da h_0=15km (Vista Longitudinale)');
yline(R_moon/r_rif,'--r',{'Superficie Lunare'});

figure(4); clf;
plot(solution.time(1:problems.nodes1), solution.control(1:problems.nodes1), 'o');
grid on;
yline(pi/2,'--r',{'Verticale','90°'});
xlabel('Tempo Adimensionale [/]');
ylabel('Angolo di spinta [rad]');
title('Angolo di controllo ottimale (Fase 1)');

figure(5); clf;
hold on;
plot(solution.time(1:problems.nodes1), ...
     solution.control(problems.nodes1+1 : 2*problems.nodes1) * T_rif, ...
     'bo', 'DisplayName', 'Fase 1 (Discesa ottimizzata)');
indice_inizio_spinta_fase2 = 2*problems.nodes1 + 1;
plot(solution.time(problems.nodes1+1 : end), ...
     solution.control(indice_inizio_spinta_fase2 : end) * T_rif, ...
     'rs', 'DisplayName', 'Fase 2 (Atterraggio verticale)');
hold off;
grid on;
legend('show', 'Location', 'best'); 
xlabel('Tempo Adimensionale [/]');
ylabel('Spinta [N]');
title('Spinta nel tempo (Fase 1 e Fase 2)'); 

figure(6); clf; 
hold on
plot(solution.time(problems.nodes1+1 : end), solution.state(problems.nodes1+1 : end, 4).*v_rif, 'o');
hold off;
grid on;
xlabel('Tempo Adimensionale [/]');
ylabel('Velocità verticale [m/s]');
title('Velocità verticale durante la fase di atterraggio (Fase 2)');

figure(7); 
plot(solution.time, solution.state(:, 6).*v_rif, 'o');
grid on;
xlabel('Tempo Adimensionale [/]');
ylabel('Velocità Orizzontale V_{\theta} [m/s]');
title('Andamento di V_{\theta} nel tempo');

figure(8); 
plot(solution.time, (solution.state(:, 1)*r_rif - R_moon)/1000, 'o'); % Altitudine in km
grid on;
xlabel('Tempo adimensionale [/]');
ylabel('Altitudine [km]');
title('Altitudine nel tempo');
yline(0,'--r',{'Superficie'});

%%
function solutionOut=risolvi(problem) 
global t_rif T_rif G M_moon R_moon r_rif v_rif m_rif a_rif
    problem.ns = length(problem.x0);  
    problem.nc = length(problem.LBangolo1); 
    problem.nuVar = 2.*problem.nodes1; 
    problem.npts1 = linspace(0, 1, problem.nodes1); 
    problem.npts2 = linspace(0, 1, problem.nodes2); 

    problem.numVar = problem.nuVar + 1;  
    problem.nuIndex_controllo = 1:problem.nodes1;   
    problem.nuIndex_spinta = (problem.nodes1+1):(2*problem.nodes1); 
    problem.ntIndex = problem.nuVar + 1; 

    uVar1 = problem.StimaAngoloT1;
    spintaVar = problem.StimaT;

    allVarGuess = [uVar1(:); spintaVar(:); problem.tau1];   
    varMin1 = repmat(problem.LBangolo1, 1, problem.nodes1)';
    varMax1 = repmat(problem.UBangolo1, 1, problem.nodes1)';
    varSMin2 = repmat(problem.LBspinta, 1, problem.nodes1)';
    varSMax2 = repmat(problem.UBspinta, 1, problem.nodes1)';
    allVarLower = [varMin1(:); varSMin2(:); problem.LBtau1];
    allVarUpper = [varMax1(:); varSMax2(:); problem.UBtau1];

    optODE = odeset('RelTol', 1e-3, 'AbsTol', 1e-3); 
    problem.optODE = optODE;

    options = optimoptions('fmincon', ...
            'Algorithm', 'sqp', ...
            'ConstraintTolerance', 1e-6, ...
            'StepTolerance', 1e-6, ...
            'Display', 'iter-detailed', ...
            'MaxIterations', 2000, ...
            'OptimalityTolerance', 1e-4, ...
            'FunctionTolerance', 1e-4);
    
    t1 = tic;
    x = fmincon(@(allVar) objectivee(allVar, problem), allVarGuess, [], [], [], [], allVarLower, allVarUpper, @(allVar) constraintss(allVar, problem), options);
    solTime = toc(t1);

    controlRet_angolo = x(problem.nuIndex_controllo); 
    controlRet_spinta = x(problem.nuIndex_spinta);
    tf1 = x(problem.ntIndex); 
    
    t_combined = [];
    y_combined = [];
    
    tspan=tf1/problem.nodes1; 
    y_prev=problem.x0; 
    psi=deg2rad(zeros(1,problem.nodes1)); 
    
    for i = 1:problem.nodes1 
        epsilon_span = [(i - 1), i]*(tspan); 
        [epsilon, y] = ode45(@(epsilon,z) satelliteODEE(epsilon, z, controlRet_angolo(i), tf1, problem, psi(i), controlRet_spinta(i)), epsilon_span , y_prev); 
        t_combined = [t_combined; epsilon_span(end)];
        y_combined = [y_combined; y(end,:)]; 
        y_prev = y(end, :)';
    end
    y_phase2_start = y_prev;
    r_current = y_phase2_start(1) * r_rif; 
    g_moon_current = G * M_moon / r_current^2;
    delta_h = 10; 
    v_atterraggio_verticale = -2; 
    tau2 = delta_h / abs(v_atterraggio_verticale); 
    tau2_adim = tau2 / t_rif;
    tspan2 = tau2_adim / problem.nodes2;
    
    for i = 1:problem.nodes2
        epsilon_span = [tf1 + (i-1)*tspan2, tf1 + i*tspan2];
        r_nodo = y_prev(1) * r_rif;
        g_moon_nodo = G * M_moon / r_nodo^2;
        m_nodo = y_prev(7) * m_rif;
        T_peso = m_nodo * g_moon_nodo; 
        T_peso_adim = T_peso / T_rif;

        [epsilon, y] = ode45(@(epsilon,z) satelliteODEE(epsilon, z, pi/2, tf1, problem, 0, T_peso_adim), epsilon_span, y_prev);
        
        t_combined = [t_combined; epsilon_span(end)];
        y_combined = [y_combined; y(end,:)];
        y_prev = y(end, :)';
    end
    tf2 = tf1 + tau2_adim; 
    obj = feval(@costt, tf1, y_combined(end, 7)) 
    TRet = zeros(problem.nodes2, 1);
    for i = 1:problem.nodes2
        idx = problem.nodes1 + i;
        if idx <= size(y_combined, 1)
            r_nodo = y_combined(idx, 1) * r_rif;
            g_moon_nodo = G * M_moon / r_nodo^2;
            m_nodo = y_combined(idx, 7) * m_rif;
            TRet(i) = (m_nodo * g_moon_nodo) / T_rif;
        end
    end

    solutionOut.tf1_tf2=[tf1,tf2]; 
    solutionOut.time = t_combined'; 
    solutionOut.control = [controlRet_angolo;controlRet_spinta; TRet];
    solutionOut.state = y_combined(:, 1:problem.ns);
    solutionOut.objective = obj; 
    solutionOut.solTime = solTime;
end      

function obj = objectivee(input, problem)
global t_rif T_rif G M_moon R_moon r_rif v_rif m_rif a_rif
    phi = input(1:100); 
    T_fase_libera = input(101:200);
    tf1 = input(201);
    t_combined = []; 
    y_combined = []; 
    tspan=tf1/problem.nodes1; 
    y_prev=problem.x0;                            
    psi=deg2rad(zeros(1,problem.nodes1));
    
    for i = 1:problem.nodes1
        epsilon_span = [(i - 1), i]*(tspan); 
        [epsilon, y] = ode45(@(epsilon,z) satelliteODEE(epsilon, z, phi(i), tf1, problem, psi(i), T_fase_libera(i)), epsilon_span , y_prev);
        t_combined = [t_combined; epsilon_span(end)];
        y_combined = [y_combined; y(end,:)];
        y_prev = y(end, :)';
    end
    delta_h = 10;
    v_atterraggio_verticale = -2;
    tau2 = delta_h / abs(v_atterraggio_verticale);
    tau2_adim = tau2 / t_rif;
    tspan2 = tau2_adim / problem.nodes2;
    for i = 1:problem.nodes2
        epsilon_span = [tf1 + (i-1)*tspan2, tf1 + i*tspan2];
        r_nodo = y_prev(1) * r_rif;
        g_moon_nodo = G * M_moon / r_nodo^2;
        m_nodo = y_prev(7) * m_rif;
        T_peso = m_nodo * g_moon_nodo; 
        T_peso_adim = T_peso / T_rif; 

        [epsilon, y] = ode45(@(epsilon,z) satelliteODEE(epsilon, z, pi/2, tf1, problem, 0, T_peso_adim), epsilon_span, y_prev);
        
        t_combined = [t_combined; epsilon_span(end)];
        y_combined = [y_combined; y(end,:)];
        y_prev = y(end, :)';
    end

    obj = feval(@costt, tf1, y_combined(end, 7)); 
end

function obj = costt(tf1, xf)
    obj = -xf;
end

function dydt = satelliteODEE(epsilon, y, phi, tf, problem, psi, T_adim)
    global G M_moon R_moon r_rif v_rif m_rif a_rif T_rif
    r = y(1) * r_rif; 
    g_moon = G * M_moon / r^2; 
    g_moon_adim = g_moon / a_rif;
    c = 290 * 9.80665 / v_rif;  

    Vr = y(4);     
    Vdelta = y(5); 
    Vtheta = y(6); 
    delta = y(2);  

    dydt = zeros(7, 1);
    dydt(1) = Vr;                                   % dr/dt
    dydt(2) = Vdelta / y(1);                        % dδ/dt
    dydt(3) = Vtheta / (y(1) * cos(delta));         % dθ/dt
    dydt(4) = (T_adim * sin(phi))/y(7) - g_moon_adim + (Vdelta^2 + Vtheta^2)/y(1);  % dVr/dt
    dydt(5) = (T_adim * cos(phi)*sin(psi))/y(7) - (Vr * Vdelta)/y(1) - (Vtheta^2 * tan(delta))/y(1);  % dVδ/dt
    dydt(6) = (T_adim * cos(phi)*cos(psi))/y(7) - (Vr * Vtheta)/y(1) + (Vdelta * Vtheta * tan(delta))/y(1);  % dVθ/dt
    dydt(7) = -T_adim / c;  % dm/dt
end

function [c, ceq] = constraintss(input, problem) 
global t_rif r_rif R_moon T_rif v_rif G M_moon m_rif a_rif
    phi = input(1:100);
    T_fase_libera = input(101:200);
    tf1 = input(201);
    
    t_combined = []; 
    y_combined = []; 
   
    c=[]; 
    tspan=tf1/problem.nodes1; 
    y_prev=problem.x0; 
    psi=deg2rad(zeros(1,problem.nodes1)); 
    
    for i = 1:problem.nodes1 
        epsilon_span = [(i - 1), i]*(tspan);
        [epsilon, y] = ode45(@(epsilon,z) satelliteODEE(epsilon, z, phi(i), tf1, problem, psi(i), T_fase_libera(i)), epsilon_span , y_prev);
        t_combined = [t_combined; epsilon_span(end)];
        y_combined = [y_combined; y(end,:)];
        y_prev = y(end, :)';
    end

    ceq(1) = y_combined(end, 6); 
    ceq(2) = y_combined(end, 4) + 2/v_rif; 
    ceq(3) = y_combined(end, 1) - 10/r_rif - R_moon/r_rif; 

    delta_h = 10;
    v_atterraggio_verticale = -2;
    tau2 = delta_h / abs(v_atterraggio_verticale);
    tau2_adim = tau2 / t_rif; 
    tspan2 = tau2_adim / problem.nodes2;
    
    for i = 1:problem.nodes2
        epsilon_span = [tf1 + (i-1)*tspan2, tf1 + i*tspan2];
        r_nodo = y_prev(1) * r_rif;
        g_moon_nodo = G * M_moon / r_nodo^2;
        m_nodo = y_prev(7) * m_rif;
        T_peso = m_nodo * g_moon_nodo; 
        T_peso_adim = T_peso / T_rif; 
        [epsilon, y] = ode45(@(epsilon,z) satelliteODEE(epsilon, z, pi/2, tf1, problem, 0, T_peso_adim), epsilon_span, y_prev);
        t_combined = [t_combined; epsilon_span(end)];
        y_combined = [y_combined; y(end,:)];
        y_prev = y(end, :)';
    end
end