%% General EAD Parameters

% Stops:
EAD.stop(1) = 725;   % GREEN 
EAD.stop(2) = 1130;  % RED
EAD.stop(3) = 1260;  % GREEN
EAD.stop(4) = 1600;  % GREEN
EAD.stop(5) = 1840;  % GREEN
EAD.stop(6) = 2010;  % RED
EAD.stop(7) = 2230;  % GREEN
% stop8 = 2320;
EAD.stop(8) = 2400;  % RED
% stop9 = 2650;
EAD.stop(9) = 2715;  % RED
EAD.stop(10) = 2870; % RED

% Setting Parameters:
EAD.d_int = 300; % [m] distance to reach the intersection (SPaT coverage)
EAD.v_c = 50/3.6; % [m/sec] current vehicle velocity
EAD.v_limit = 60/3.6; % [m/sec]
EAD.v_max_allowed = 80/3.6; % [m/sec] max velocity on the road
EAD.jerk_max_allowed = 3; % [m/s^3] max jerk
EAD.acc_max_allowed = 2.5; % [m/s^2] max acceleration

% % Optimized Velocity Profile:
% v_c1 = 13.99; % [m/sec] initial speed at EAD coverage (stop2) at time 70
% v_c2 = 10.07; % [m/sec]
% v_c3 = 7.941; % [m/sec]
% v_c4 = 5.870; % [m/sec]
% v_c5 = 4.456; % [m/sec]

% Parameters to be chosen:
EAD.s = 0.45;
EAD.a = 0.74;

% Stop 2: The vehicle decelerates to make it for arrival at green phase
EAD.t_l1 = 40; % [sec] min time to reach the green phase
EAD.t_h1 = 70; % [sec] max time to reach the green phase

EAD.v_l1 = EAD.d_int/EAD.t_h1; % [m/sec] min velocity to reach the green phase
EAD.v_h1 = EAD.d_int/EAD.t_l1; % [m/sec] max velocity to reach the green phase
EAD.v_min1 = max(0,EAD.v_l1); % [m/sec] min possible velocity to reach the green phase
EAD.v_max1 = min(EAD.v_h1,EAD.v_limit); % [m/sec] max possible velocity to reach the green phase

% Stop 6: The vehicle decelerates to make it for arrival at green phase
EAD.t_l2 = 35; % [sec] min time to reach the green phase
EAD.t_h2 = 65; % [sec] max time to reach the green phase

EAD.v_l2 = EAD.d_int/EAD.t_h2; % [m/sec] min velocity to reach the green phase
EAD.v_h2 = EAD.d_int/EAD.t_l2; % [m/sec] max velocity to reach the green phase
EAD.v_min2 = max(0,EAD.v_l2); % [m/sec] min possible velocity to reach the green phase
EAD.v_max2 = min(EAD.v_h2,EAD.v_limit); % [m/sec] max possible velocity to reach the green phase

% Stop 8: The vehicle decelerates to make it for arrival at green phase
EAD.t_l3 = 45; % [sec] min time to reach the green phase
EAD.t_h3 = 60; % [sec] max time to reach the green phase

EAD.v_l3 = EAD.d_int/EAD.t_h3; % [m/sec] min velocity to reach the green phase
EAD.v_h3 = EAD.d_int/EAD.t_l3; % [m/sec] max velocity to reach the green phase
EAD.v_min3 = max(0,EAD.v_l3); % [m/sec] min possible velocity to reach the green phase
EAD.v_max3 = min(EAD.v_h3,EAD.v_limit); % [m/sec] max possible velocity to reach the green phase

% Stop 9: The vehicle decelerates to make it for arrival at green phase
EAD.t_l4 = 60; % [sec] min time to reach the green phase
EAD.t_h4 = 75; % [sec] max time to reach the green phase

EAD.v_l4 = EAD.d_int/EAD.t_h4; % [m/sec] min velocity to reach the green phase
EAD.v_h4 = EAD.d_int/EAD.t_l4; % [m/sec] max velocity to reach the green phase
EAD.v_min4 = max(0,EAD.v_l4); % [m/sec] min possible velocity to reach the green phase
EAD.v_max4 = min(EAD.v_h4,EAD.v_limit); % [m/sec] max possible velocity to reach the green phase

% Stop 10: The vehicle decelerates to make it for arrival at green phase
EAD.t_l5 = 55; % [sec] min time to reach the green phase
EAD.t_h5 = 70; % [sec] max time to reach the green phase

EAD.v_l5 = EAD.d_int/EAD.t_h5; % [m/sec] min velocity to reach the green phase
EAD.v_h5 = EAD.d_int/EAD.t_l5; % [m/sec] max velocity to reach the green phase
EAD.v_min5 = max(0,EAD.v_l5); % [m/sec] min possible velocity to reach the green phase
EAD.v_max5 = min(EAD.v_h5,EAD.v_limit); % [m/sec] max possible velocity to reach the green phase

EAD.t_0 = 0;
EAD.t_1 = pi/2/EAD.s;
EAD.t_2 = pi/2/EAD.a + pi/2/EAD.s;
EAD.t_3 = EAD.d_int/EAD.v_max1;
