import json
import sys
from collections import defaultdict

def main(file_path, threshold):
    # Definition of flags map
    protocols = {
        "network": 0, "communication": 0, "auth": 0, "rdp": 0, "mqtt": 0, "dcerpc": 0, "ike": 0, "modbus": 0,
        "pgsql": 0, "quic": 0, "rfb": 0, "tftp": 0
    }
    # Open and read eve.json file
    try:
        with open(file_path, 'r') as file:
            for line in file:
                # Parse each line as JSON object
                try:
                    event = json.loads(line)
                    # Find json field 'event_type' which indicates the protocol 
                    proto = event.get("event_type", "").lower()

                    # ip means both ipv4 and ipv6 
                    if proto == "ip": 
                        src_ip = event.get("src_ip", "")
                        try:
                            ip = ipaddress.ip_address(src_ip)
                            if ip.version == 6:  
                                protocols["network"] += 1
                        except ValueError:
                            pass
                        continue
                        
                    #flag network
                    if proto == "http" or proto == "tls" or proto == "dns" or proto == "dhcp" or proto == "arp":
                    	protocols["network"] += 1
                    
                    #flag communication
                    if proto == "smb" or proto == "ftp" or proto == "ssh" or proto == "bittorrent_dht":
                    	protocols["communication"] += 1
                    
                    # Special case: smb -> dcerpc and smb -> kerberos
                    smb = event.get("smb", {})
                    if "dcerpc" in smb:
                        # dcerpc in a field of smb event_type
                        protocols["dcerpc"] += 1
                    if "kerberos" in smb:
                        # krb5 is a field of smb event_type
                        protocols["auth"] += 1
                        
                    if proto in protocols:
                        protocols[proto] += 1
                        
                except json.JSONDecodeError:
                    print(f"Parsing error in line: {line.strip()}")
    except FileNotFoundError:
        print(f"File not found: {file_path}")
        sys.exit(1)

    # Compare with threshold
    for proto, count in protocols.items():
        if count >= threshold:
            # enable if higher
            print(f"--enable-{proto}", end = " ")
        else:
            # disable if less
            print(f"--disable-{proto}", end = " ")

if __name__ == "__main__":
    # Check parameters
    if len(sys.argv) != 3:
        print("Usage: python script.py <path_to_eve.json> <threshold>")
        sys.exit(1)

    # Read parameters
    file_path = sys.argv[1]
    try:
        threshold = int(sys.argv[2])
    except ValueError:
        print("Threshold has to be an integer.")
        sys.exit(1)

    # execute main function
    main(file_path, threshold)

