%% DATI MOTORE NUOVO: STATORE CORELESS
P=350;      % W
n=350;      % rpm
V_ph=13.86; % V
I_ph= 8.42; % A
pp=20;
m1=3;        % numero di fasi
f=58.33;    % Hz
lm=5.5;     % mm (altezza magnete)

dist_mg = 6.5;  % mm distanza tra magneti

Br=1.30;    % T
Hcj=1353;   % A/m

load('dati.mat');
pi=3.141592;

rho=1.76e-8;    % @20°C Ohm*m
sigma=58e6;     % @20°C S/m
mu_cu= 1.2566290e-6; % H/m permeabilità del rame
mu_0=4*pi*1e-7; 
%% calcolo campo magnetico generato da magneti
mu_rrec=1+Br/Hcj;

t=10e-3;    % m airgap (come nel vecchio generatore)
tw=8e-3;    % m spessore avvolgimenti 

g=(t-tw)/2; 

Bmg=Br/(1+(mu_rrec*(g+tw/2)/(lm*1e-3)));
%% dati per generare il modello
% Parametri di progettazione
R_ext = 104e-3;    % Raggio esterno in m
R_int = 15e-3;     % Raggio interno in m
s_mg = 25.3e-3;     % "base maggiore" del magnete in mm 
h_mg_radiale=37e-3;
J=linspace(4,10,6); %A/mm^2
kw1=0.933013;       %fattore ricavato da Dolomites
A_cond= I_ph/6;        % Area del conduttore in mm2
Ae=s_mg*h_mg_radiale;    % nel testo dice di considerare come area magnetica solo l'area del magnete
d_filo=sqrt(4.*A_cond/pi);  % in mm
N1=round(V_ph/(4.44*f*Bmg*kw1*Ae));       %4.44=2*pi/sqrt(2)
%%

% Equazioni prese da tesi 2023 PoliMi
            
s1=24;           % numero di "slot" figurativi
nc=s1/m1;       % numero di bobine x fase for a double layer windings
Ntc=N1/nc;      % numero di spire per bobina
% cioè con questo dato dovremmo, dato il numero totale di spire 
% in serie per fase N1, distribuirle equamente tra le bobine di quella fase.

q1=s1/(pp*m1);   % numero di coil side per polo per fase 
tau_c=s1/pp;    % passo polare misurato in coil sides
tau=2*pi*(R_ext-R_int)/pp;          % passo polare in m
alpha_i=s_mg/tau;              % il rapporto tra la larghezza del magnete e il passo polare
phi_mg=alpha_i*Bmg*pi/pp *(R_ext^2-R_int^2);    % Wb
kd1=sind((pi/(2*m1))/(q1*sind(pi/(2*m1*q1))));    % fattore di distribuzione
kp1=kw1/kd1;                         % pitch factor

ke=pi*sqrt(2)*pp/2*N1*kw1*phi_mg;
n_sec=n/60; %per calcolare la velocità in giri al secondo/Hz
kt=ke*m1/(2*pi);
EMF=ke*n_sec;
Td=kt*I_ph;
P_elm=n_sec*Td*pi*2;


lambda=phi_mg*N1
emf=4.44*58.33*lambda
%%
%Calcolo resistenza di fase
rho_cu=rho*(1+0.0039*(25-20));
Lft=2*(0.0707+0.0093);
Lsp=90*Lft
s_cu=1.5e-6
R_f=rho_cu*Lsp/s_cu


%%
I=linspace(0, 8, 100);
P_j=R_f*I.^2;

plot(I, P_j, 'r-o', 'LineWidth', 0.5)


xlabel('Current [A]');
ylabel('Joule Losses [W]');
grid on
legend
set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
set(gcf, 'Color', 'w'); % Sfondo bianco della figura
box on; % Mantiene il bordo visibile
%%

%n=linspace(0,350,17);
n=0:20:360;
%n=[0,50,100,150,200,250, 300,350];
%I=[0,1,2,3,4,5,6,8];
I=0:0.44:8;
%I=linspace(0,8,17);
T=kt*I;
Pelt=T.*(n*pi/30);
figure 

yyaxis right
plot(n, T, '-.', 'Color', [1, 0.5, 0], 'LineWidth', 0.5)
ylim([0 30])   % Imposta i limiti per la coppia

xlabel('speed [rpm]');
ylabel('Torque [Nm]');
xlim([0 350])
hold on
yyaxis left
ylim([0 600])
plot(n, Pelt, 'b-.', 'LineWidth',0.5);

ylabel('Power [W]');
grid on
legend
set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
set(gcf, 'Color', 'w'); % Sfondo bianco della figura
box on; % Mantiene il bordo visibile
%%
% Dati
I = linspace(0, 8, 100); % Corrente da 0 a 8 A

P_j = R_f * I.^2; % Perdite per effetto Joule

% Creazione del grafico principale
figure;
plot(I, P_j, 'r-o', 'LineWidth', 0.5, 'MarkerSize', 3, 'MarkerFaceColor', 'r');
hold on; % Mantiene il grafico attivo per aggiungere altri elementi

% Punto da evidenziare a I = 6 A
I_highlight = 6;
Pj_highlight = R_f * I_highlight^2; % Calcolo della potenza associata a 6 A

% Plottiamo il punto evidenziato con un marker più grande e un colore diverso
plot(I_highlight, Pj_highlight, 'bo', 'MarkerSize', 5, 'MarkerFaceColor', 'b', 'LineWidth', 1.5);

% Aggiungere una freccia e una descrizione del punto
text(I_highlight, Pj_highlight, '  \leftarrow 6A - evaluation point', 'FontSize', 10, 'Color', 'b');

% Etichette, griglia e personalizzazioni
xlabel('Current [A]');
ylabel('Joule Losses [W]');
grid on;
legend('Joule Losses for the coreless technology', 'max current for the previous generator', 'Location', 'northwest');
set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
set(gcf, 'Color', 'w'); % Sfondo bianco della figura
box on; % Mantiene il bordo visibile

hold off; % Termina la sovrapposizione di nuovi elementi
%%
Pe=1.65*(1.5*1e-6)*Lsp*Bmg^2*(d_filo*1e-3)^2*f^2/rho; %5.7 W