% clear all
% clc
%% Dati: (misure di lunghezza tutte in millimetri)
f=58.33;                               % frequenza in [Hz]
%In= 8.42/2;                             % corrente nominale in [A]
Imax= 10;                           % corrente massima in [A]
h_mg= 5.5;                         % altezza magneti  in mm                
dist_mg= 6.5;                      % distanza tra i magneti in mm

h_airgap = 3;                    % distanza statore in pcb e magneti rotore
w_stator= 10;                        % -- provo spessore pcb
h_cond=4;                   % altezza conduttori di rame in mm

r_pcb= (104)*2*pi/10;                          % raggio pcb in mm
l_rotor= 104*2*pi/10;                        % diametro rotore in cm
h_rotor= 14;                      % altezza rotore
n_mg=20/10;                            % numero magneti
d_mg = 25.5;        % diametro magneti
% Lunghezza per ciascun trace
n_traces=90*3/10;
l_cond= 2;                % lunghezza assiale conduttori in rame in mm

dist_cond=0.4202;                % distanza tra i conduttori in mm
offset=(r_pcb-(n_traces-1)*(l_cond+dist_cond))/2;
offset_mg=(l_rotor-n_mg*(d_mg+dist_mg))/2;
%% Definizione problema
openfemm;                                           %lancio FEMM
path='C:\Users\ireee\OneDrive - Politecnico di Torino\2024 Tesi LM - Irene ALBERTI\matlab';
newdocument(0) 

name_fem = 'prove_coreless';
mi_saveas([path,name_fem]);
mi_probdef(0,'millimeters','planar',1e-8,50,2);         % definizione del problema

%% INSERIMENTO PUNTI DI ISPEZIONE (2 rotori e 1 statore in pcb)
% pcb 
mi_addnode(0,0);
mi_addnode(r_pcb,0);
mi_addnode(0,w_stator);
mi_addnode(r_pcb,w_stator);

%inserisco i conduttori di rame *sopra e sotto
k=1;
while k<n_traces
mi_addnode(offset/2+(k-1)*(l_cond+dist_cond),w_stator);
mi_addnode(offset/2+(k-1)*(l_cond+dist_cond),0);

mi_addnode(offset/2+(k-1)*(l_cond+dist_cond),w_stator-h_cond);
mi_addnode(offset/2+(k-1)*(l_cond+dist_cond),h_cond);
mi_addnode(offset/2+k*l_cond+(k-1)*dist_cond,w_stator);
mi_addnode(offset/2+k*l_cond+(k-1)*dist_cond,w_stator-h_cond);
mi_addnode(offset/2+k*l_cond+(k-1)*dist_cond,0);
mi_addnode(offset/2+k*l_cond+(k-1)*dist_cond,h_cond);
k=k+1;
end
%%
div=round(l_rotor/(d_mg+dist_mg));
% questo indice perchè io voglio che ci siano tanti magneti quanti
% potrebbero starcene lungo il rotore

k=1;
while k<div+1
% magneti "sopra"
mi_addnode(offset_mg/2+(k-1)*(d_mg+dist_mg),w_stator+h_airgap);         % da 0 in basso
mi_addnode(k*d_mg+(k-1)*dist_mg,w_stator+h_airgap);         % fine del mag in basso
mi_addnode(offset_mg/2+(k-1)*(d_mg+dist_mg),w_stator+h_airgap+h_mg);    % da 0 in alto
mi_addnode(k*d_mg+(k-1)*dist_mg,w_stator+h_airgap+h_mg);    % da fine del mag in alto
% k=1+k;
% end
% k=1;
% while k<div+1
% magneti "sotto"
mi_addnode(offset_mg/2+(k-1)*(d_mg+dist_mg),-(+h_airgap)); 
mi_addnode(k*d_mg+(k-1)*dist_mg,-(+h_airgap));
mi_addnode(offset_mg/2+(k-1)*(d_mg+dist_mg),-(h_airgap+h_mg));
mi_addnode(k*d_mg+(k-1)*dist_mg,-(h_airgap+h_mg));
k=1+k;
end

% rotore1
mi_addnode(0,w_stator+h_airgap+h_mg);
mi_addnode(0,w_stator+h_airgap+h_mg+h_rotor);
mi_addnode(l_rotor,w_stator+h_airgap+h_mg);
mi_addnode(l_rotor,w_stator+h_airgap+h_mg+h_rotor);
% rotore2
mi_addnode(0,-(+h_airgap+h_mg));
mi_addnode(0,-(+h_airgap+h_mg+h_rotor));
mi_addnode(l_rotor,-(+h_airgap+h_mg));
mi_addnode(l_rotor, -(+h_airgap+h_mg+h_rotor));

%% Definisco i lati dello statore in pcb
mi_addsegment(r_pcb,0,r_pcb,w_stator);
mi_addsegment(r_pcb,w_stator,0,w_stator);
mi_addsegment(0,w_stator,0,0);
mi_addsegment(0,0,r_pcb,0);

%% Definisco i conduttori di rame
k=1;
while k<n_traces
%sopra
mi_addsegment(offset/2+(k-1)*(l_cond+dist_cond),w_stator,offset/2+(k-1)*(l_cond+dist_cond),w_stator-h_cond);
mi_addsegment(offset/2+(k-1)*(l_cond+dist_cond),w_stator-h_cond,k*l_cond+(k-1)*dist_cond,w_stator-h_cond);
mi_addsegment(offset/2+k*l_cond+(k-1)*dist_cond,w_stator-h_cond,k*l_cond+(k-1)*dist_cond,w_stator);
%mi_addsegment(k*l_cond+(k-1)*dist_cond,w_stator,(k-1)*(l_cond+dist_cond),w_stator);
%sotto
mi_addsegment(offset/2+(k-1)*(l_cond+dist_cond),0,offset/2+(k-1)*(l_cond+dist_cond),h_cond);
mi_addsegment(offset/2+(k-1)*(l_cond+dist_cond),h_cond,k*l_cond+(k-1)*dist_cond,h_cond);
mi_addsegment(offset/2+k*l_cond+(k-1)*dist_cond,h_cond,k*l_cond+(k-1)*dist_cond,0);
%mi_addsegment(k*l_cond+(k-1)*dist_cond,0,(k-1)*(l_cond+dist_cond),0);
k=k+1;
end
%% Definisco i magneti sotto
k=1;
while k<div+1
mi_addsegment(offset_mg/2+(k-1)*(d_mg+dist_mg),-(h_airgap),offset_mg/2+(k-1)*(d_mg+dist_mg),-(h_airgap+h_mg));
mi_addsegment(offset_mg/2+(k-1)*(d_mg+dist_mg),-(h_airgap),k*d_mg+(k-1)*dist_mg,-(h_airgap));
mi_addsegment(k*d_mg+(k-1)*dist_mg,-(h_airgap),k*d_mg+(k-1)*dist_mg,-(h_airgap+h_mg));
%mi_addsegment(k*d_mg+(k-1)*dist_mg,-(h_airgap+h_cond+h_mg),(k-1)*(d_mg+dist_mg),-(h_airgap+h_mg+h_cond));
% k=1+k;
% end
% %% Definisco i magneti sopra
% k=1;
% while k<div
mi_addsegment(offset_mg/2+(k-1)*(d_mg+dist_mg),w_stator+h_airgap,offset_mg/2+(k-1)*(d_mg+dist_mg),w_stator+h_airgap+h_mg);
mi_addsegment(offset_mg/2+(k-1)*(d_mg+dist_mg),w_stator+h_airgap,k*d_mg+(k-1)*dist_mg,w_stator+h_airgap);
mi_addsegment(k*d_mg+(k-1)*dist_mg,w_stator+h_airgap,k*d_mg+(k-1)*dist_mg,w_stator+h_airgap+h_mg);
%mi_addsegment(k*d_mg+(k-1)*dist_mg,w_stator+h_cond+h_airgap+h_mg,(k-1)*(d_mg+dist_mg),w_stator+h_cond+h_airgap+h_mg);
k=1+k;
end 
%% Definisco il rotore1 (sopra)
mi_addsegment(0,w_stator+h_airgap+h_mg,l_rotor,w_stator+h_airgap+h_mg);
mi_addsegment(0,w_stator+h_airgap+h_mg,0,w_stator+h_airgap+h_mg+h_rotor);
mi_addsegment(0,w_stator+h_airgap+h_mg+h_rotor,l_rotor,w_stator+h_airgap+h_mg+h_rotor);
mi_addsegment(l_rotor,w_stator+h_airgap+h_mg+h_rotor,l_rotor,w_stator+h_airgap+h_mg);
%% Definisco il rotore2 (sotto)
mi_addsegment(0,-(h_airgap+h_mg),l_rotor,-(h_airgap+h_mg));
mi_addsegment(0,-(h_airgap+h_mg),0,-(h_airgap+h_mg+h_rotor));
mi_addsegment(0,-(h_airgap+h_mg+h_rotor),l_rotor,-(h_airgap+h_mg+h_rotor));
mi_addsegment(l_rotor,-(h_airgap+h_mg+h_rotor),l_rotor,-(h_airgap+h_mg));
%% Definisco i materiali:
% Materiale dello statore in pcb & del traferro
mi_getmaterial('Air');
% Materiale magneti
mi_addmaterial('N42H', 1.05, 1.05, 1.353e6, 0, 0.0667, 0, 0, 1, 0, 0);
% Materiale conduttori in rame
cond_Cu=58;                     %conducibilità rame 
mi_addmaterial ('Cu',1,1,0,0,cond_Cu);
% Materiale rotori
mi_getmaterial('Pure Iron');
mi_getmaterial('1006 Steel');
%% Materiale PCB
mi_addblocklabel(r_pcb/2,w_stator/2);
mi_selectlabel(r_pcb/2,w_stator/2);
mi_setblockprop('Air',1,0,'',0,0,0);
mi_clearselected;
%% Materiale magneti 
k=1;
while k<div+1
    if mod(k, 2) == 0
    %sopra
    mi_addblocklabel(d_mg/2+offset_mg/2+(k-1)*(d_mg+dist_mg),w_stator+h_airgap+h_mg/2);
    mi_selectlabel(d_mg/2+offset_mg/2+(k-1)*(d_mg+dist_mg),w_stator+h_airgap+h_mg/2);
    mi_setblockprop('N42H',0, 0.1,'',+90,0,0);
    mi_clearselected;
    %sotto
    mi_clearselected;
    mi_addblocklabel(d_mg/2+offset_mg/2+(k-1)*(d_mg+dist_mg),-(h_airgap+h_mg/2));
    mi_selectlabel(d_mg/2+offset_mg/2+(k-1)*(d_mg+dist_mg),-(h_airgap+h_mg/2));
    mi_setblockprop('N42H', 0, 0.1, '', +90, 0, 0);
    mi_clearselected;
    else 
        %sopra
        mi_addblocklabel(d_mg/2+offset_mg/2+(k-1)*(d_mg+dist_mg),w_stator+h_airgap+h_mg/2);
        mi_selectlabel(d_mg/2+offset_mg/2+(k-1)*(d_mg+dist_mg),w_stator+h_airgap+h_mg/2);
        mi_setblockprop('N42H',0, 0.1,'',-90,0,0);
        mi_clearselected;
        %sotto
        mi_addblocklabel(d_mg/2+offset_mg/2+(k-1)*(d_mg+dist_mg),-(h_airgap+h_mg/2));
        mi_selectlabel(d_mg/2+offset_mg/2+(k-1)*(d_mg+dist_mg),-(h_airgap+h_mg/2));
        mi_setblockprop('N42H', 0, 0.1, '', -90, 0, 0);
        mi_clearselected;
    end 
k=1+k;
end
%% Materiale rotore sopra
mi_addblocklabel(l_rotor/2,w_stator+h_airgap+h_mg+h_rotor/2);
mi_selectlabel(l_rotor/2,w_stator+h_airgap+h_mg+h_rotor/2);
mi_setblockprop('1006 Steel',1, 0, '', 0, 0, 0);
mi_clearselected;
%% Materiale rotore sotto
mi_addblocklabel(l_rotor/2,-(h_airgap+h_mg+h_rotor/2));
mi_selectlabel(l_rotor/2,-(h_airgap+h_mg+h_rotor/2));
mi_setblockprop('1006 Steel', 1, 0, '', 0, 0, 0);
mi_clearselected;

%% Materiale airgap
% sopra
mi_addblocklabel(d_mg+dist_mg/2,w_stator+h_airgap/2);
mi_selectlabel(d_mg+dist_mg/2,w_stator+h_airgap/2);
mi_setblockprop('Air',1,0,'',0,0,0);
mi_clearselected;
% sotto
mi_addblocklabel(d_mg+dist_mg/2,-(h_airgap/2));
mi_selectlabel(d_mg+dist_mg/2,-(h_airgap/2));
mi_setblockprop('Air',1,0,'',0,0,0);
mi_clearselected;

%% % creo un sistema trifase di correnti
T = 1/f;
t = 0:40:2*T; % Cambiato per adattare al nuovo range temporale
w = 2*pi*f;
ph_shift = 2*pi/3;

In = 0;
Ia = In * cos(w*t); % Fase A
Ib = In * cos(w*t - ph_shift); % Fase B
Ic = In * cos(w*t - ph_shift*2); % Fase C

% Definizione delle sorgenti POSITIVE e NEGATIVE
mi_addcircprop('A+', Ia, 1);
mi_addcircprop('B+', Ib, 1);
mi_addcircprop('C+', Ic, 1);
mi_addcircprop('A-', -Ia, 1);
mi_addcircprop('B-', -Ib, 1);
mi_addcircprop('C-', -Ic, 1);

% Definiamo la sequenza di correnti in modo più semplice
correnti = {'A+', 'A+', 'A+', 'A+', 'B-', 'B-', 'B-', 'B-', 'C+', 'C+', 'C+', 'C+', ...
            'A-', 'A-', 'A-', 'A-', 'B+', 'B+', 'B+', 'B+', 'C-', 'C-', 'C-', 'C-'};

% Ciclo per le tracce
for k = 1:n_traces-1
    % Calcola la posizione della traccia
    pos = l_cond/2 + offset/2 + (k-1)*(l_cond + dist_cond);

    % Determina la corrente da assegnare alla traccia corrente
    corrente = correnti{mod(k-1, 24)+1}; % Uso il modulo per ripetere ciclicamente la sequenza

    % Aggiungi le tracce corrispondenti a ciascuna corrente
    mi_addblocklabel(pos, w_stator - h_cond/2);
    mi_selectlabel(pos, w_stator - h_cond/2);
    mi_setblockprop('Cu', 0, 0.1, corrente, 0, 0, 0);
    mi_clearselected;

    % Aggiungi la traccia sul lato inferiore
    mi_addblocklabel(pos, h_cond/2);
    mi_selectlabel(pos, h_cond/2);
    mi_setblockprop('Cu', 0, 0.1, corrente, 0, 0, 0);
    mi_clearselected;
end
%% Condizioni al contorno
mi_addboundprop('P_BCair_sopra', 0, 0, 0, 0, 0, 0, 0, 0, 4, 0 ,0);
mi_addboundprop('P_BCair_sotto', 0, 0, 0, 0, 0, 0, 0, 0, 4, 0 ,0);
mi_addboundprop('P_BCpcb', 0, 0, 0, 0, 0, 0, 0, 0, 4, 0 ,0);
mi_addboundprop('P_BCrotor_sopra', 0, 0, 0, 0, 0, 0, 0, 0, 4, 0 ,0);
mi_addboundprop('P_BCrotor_sotto', 0, 0, 0, 0, 0, 0, 0, 0, 4, 0 ,0);
% periodico usato x dire che parte dx e sx sono collegate

% Aggiungo la regione x il segmento destro
mi_addsegment(l_rotor, w_stator+h_airgap+h_mg, l_rotor, w_stator); % definisco il segmento dell'airgap sopra
mi_addsegment(l_rotor, 0, l_rotor, -(h_airgap+h_mg)); % definisco il segmento dell'airgap sotto
% Aggiungo la regione x il segmento sinistro
mi_addsegment(0,w_stator+h_airgap+h_mg,0, w_stator); % airgap fino al magnete sopra
mi_addsegment(0,-(h_airgap+h_mg),0,0);   % airgap fino al magnete sotto

% definisco boundary laterale dx

mi_selectsegment(l_rotor, w_stator+(h_airgap+h_mg)/2);        % seleziono il segmento dell'airgap sopra
mi_setsegmentprop('P_BCair_sopra', 1, 0, 0, 0); 
mi_clearselected;

mi_selectsegment(l_rotor, -(h_airgap+h_mg)/2);
mi_setsegmentprop('P_BCair_sotto', 1, 0, 0, 0); 
mi_clearselected;

mi_selectsegment(l_rotor, w_stator/2);                          % seleziono il pcb
mi_setsegmentprop('P_BCpcb', 1, 0, 0, 0); 
mi_clearselected;

mi_selectsegment(l_rotor, -(h_airgap + h_mg + h_rotor/2)); % seleziono il rotore sotto
mi_setsegmentprop('P_BCrotor_sotto', 1, 0, 0, 0); 
mi_clearselected;

mi_selectsegment(l_rotor, w_stator+h_airgap+h_mg+h_rotor/2); % seleziono il rotore sopra
mi_setsegmentprop('P_BCrotor_sopra', 1, 0, 0, 0); 
mi_clearselected;


%  definisco boundary sinistro
mi_selectsegment(0, w_stator+h_airgap+h_mg+h_rotor/2); % seleziono il rotore sopra
mi_setsegmentprop('P_BCrotor_sopra', 1, 0, 0, 0); 
mi_clearselected;

mi_selectsegment(0,w_stator+h_airgap/2);            % seleziono l'airgap sopra
mi_setsegmentprop('P_BCair_sopra', 1, 0, 0, 0); 
mi_clearselected;

mi_selectsegment(0,w_stator/2);                            % seleziono la pcb
mi_setsegmentprop('P_BCpcb', 1, 0, 0, 0); 
mi_clearselected;

mi_selectsegment(0,-(h_airgap/2));               % seleziono l'airgap sotto 
mi_setsegmentprop('P_BCair_sotto', 1, 0, 0, 0); 
mi_clearselected;

mi_selectsegment(0,-(h_airgap+h_mg+h_rotor/2));  % seleziono il rotore sotto
mi_setsegmentprop('P_BCrotor_sotto', 1, 0, 0, 0); 
mi_clearselected;

mi_addboundprop('DirichletBC', 0, 0, 0, 0, 0, 0, 0, 0, 0);  % A = 0
% dirichlet lo uso x definire la regione in cui sto studiando il mio campo
% magnetico

% % definisco la regione sopra e sotto
mi_selectsegment(l_rotor/2, w_stator+h_airgap+h_mg+h_rotor);                          % seleziono il rotore sopra
mi_setsegmentprop('DirichletBC', 0, 1, 0, 0);
mi_clearselected;

mi_selectsegment(l_rotor/2, -( h_airgap + h_mg + h_rotor));
mi_setsegmentprop('DirichletBC', 0, 1, 0, 0);
mi_clearselected;
% %%
% mi_createmesh();
% mi_analyze();
% mi_loadsolution;

