%% Dati di targa
P_nom  =250;             % kW
n_nom = 200;              % rpm
V_nom = 24;               % V in AC
I_nom = 6.01;             % A
w_nom = 200*pi/30;        % rad/s
efficiency = 0.85; 
m = 3;                    % trifase
f_nom = n_nom*20/120;    % Hz
cosphi = P_nom*1000/(sqrt(3)*V_nom*I_nom);
mu_0 = pi*4e-7;           % H/m
pi = 3.14159;
%% DATI MOTORE NUOVO: STATORE CORELESS
V_ph=13.86; % V
I_ph= 6; % A
pp=20;
m1=3;        % numero di fasi
f=33.33;    % Hz
lm=5.5;     % mm (altezza magnete)

dist_mg = 6.5;  % mm distanza tra magneti

Br=1.30;    % T
Hcj=1353;   % A/m

load('dati.mat');
pi=3.141592;

rho=1.76e-8;    % @20°C Ohm*m
sigma=58e6;     % @20°C S/m
mu_cu= 1.2566290e-6; % H/m permeabilità del rame
mu_0=4*pi*1e-7;
%% Dati sperimentali ottenuti da TEST su AFPMSM
R_avv = 1.673;            % Ohm - da test
%L_fase = 0.5;             % mH da test
phi_mg = 111.9;           % mVs o mWb
Pout = 32.02*4.926;       % W @200rpm con 32.02 V e 4.926 A
Pin = 250;                % W
% N_tot = 17*20;               % numero di spire  totali
eta_eff = Pout/Pin;
rho_mis= 1.83e-8;         % materiale filo Ohm*m
A_filo = 1.6513;          % mm^2
lungh_filo = (R_avv*A_filo/rho_mis)*10^(-3);     % mm

%% DIMENSIONI
% Statore
R_int_stat = 43.8;          % mm 
R_est_stat = 114.5;         % mm 
R_case = 132.5;             % mm - Con il case esterno
R_first_step = 105;         % mm - dal primo scalino verso l'esterno
lungh_second_step = 20;     % mm 

h_disco = 33.2;             % mm 
h1 = 8;                     % mm
h2 = 4.5;                   % mm
h3 = 20.3;                  % mm
h4 = 5.5;                   % mm
h_eff = 9.3;                % mm

% Rotore
R_est_rot = 104;            % mm
R_int_rot = 15;             % mm
h_tot_disco = 14;           % mm - altezza magnete+disco
R_b_mg = 66;                % mm - raggio prima dei magneti

% magneti
l_mg = 37;                  % mm
B_mg = 25.5;                % mm
b_mg = 14;                  % mm 
h_mg = 5.5;                 % mm

% altezza rotore + statore + rotore
H_tot = 39.8;               % mm

%% Informazioni magnete N-42H
Br_min = 1.28;              % T - induzione residua
Br_nom = 1.3;               % T
Br_max = 1.32;              % T
HcB = 955;                  % kA/m - coercitività
HcJ = 1.353;                % kA/m coercitività intrinseca
BH_max_min = 318;           % kJ/m^3
BH_max_nom= 330;            % kJ/m^3
BH_max_max= 342;            % kJ/m^3

% %% dimensionamento
% %2020 - Tokgoz
% % Calcoli per considerazioni
% % 1) voglio confrontare lo spazio che occupa lo statore
% % con lo spazio che ho misurato con i test
% 
% V_avv = A_filo*lungh_filo;               %mm^3
% % ho diviso i tre scalini del rotore in 3 cilindri cavi e ne ho calcolato
% % l'area
% V1 = pi*h3*lungh_second_step^2;
% V2 = pi*(h_disco-h1*2-h2*2)*(R_first_step^2-(R_int_stat+lungh_second_step)^2);
% V3 = pi*(h_disco-h1*2)*(R_est_stat^2-R_first_step^2);
% 
% Vtot=V1+V2+V3;
%%
% 2) voglio confrontare il flusso teorico di un polo magnetico 
% con il flusso misurato nei test
x= (h_tot_disco*2+h_disco-H_tot)/2;
h_airgap=x-(h3-h4*2);
% in realtà non possiamo dire se così è giusto il calcolo dell'airgap
% perchè non sappiamo dove sia l'avvolgimento, o meglio, su quale dei tre
% anelli di cui abbiamo fatto il calcolo è contenuto. probabilmente
% l'avvolgimento si trova dei due anelli più esterni. non è dunque
% possibile fare una stima corretta del campo magnetico.

Bg = Br_nom * h_mg*10^(-3)/(2*h_mg*10^(-3)+mu_0*h_airgap*10^(-3))

% phi_pp1= 2*Bg/3.14 *3.14*(0.104^2-0.015^2)/10;

%%
R=1.672; %ohm
I=linspace(0,6.01,100);
P=R*I.^2;

figure
plot(I, P, '-o','color', 'r', 'LineWidth', 0.5); % Linea rossa tratteggiata, spessore 2
xlabel('current [A]'); % Etichetta asse X
ylabel('Joule Losses [W]'); % Etichetta asse Y
grid on; % Mostra la griglia
set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
set(gcf, 'Color', 'w'); % Sfondo bianco della figura
box on; % Mantiene il bordo visibile


%% calcolo campo magnetico generato da magneti
mu_rrec=1+Br/Hcj;

t=10e-3;    % m airgap (come nel vecchio generatore)
tw=8e-3;    % m spessore avvolgimenti 

g=(t-tw)/2; 

Bmg=Br/(1+(mu_rrec*(g+tw/2)/(lm*1e-3)));
%% dati per generare il modello
% Parametri di progettazione
R_ext = 104e-3;    % Raggio esterno in m
R_int = 15e-3;     % Raggio interno in m
s_mg = 25.3e-3;     % "base maggiore" del magnete in mm 
h_mg_radiale=37e-3;
m1=3;

tau=2*pi*(R_ext-R_int)/pp;          % passo polare in m
alpha_i=s_mg/tau;              % il rapporto tra la larghezza del magnete e il passo polare
phi_mg=alpha_i*Bmg*pi/pp *(R_ext^2-R_int^2);    % Wb
f_n=200*20/120;
% N=N1*kw
Ae=s_mg*h_mg_radiale; 

N=round(13.6/(4.44*f_n*phi_mg))
s1=20;           % numero di "slot" figurativi
nc=s1/m1;       % numero di bobine x fase for a double layer windings
Ntc=N/nc;      % numero di spire per bobina
q1=s1/(pp*m1);   % numero di coil side per polo per fase 
tau_c=s1/pp;    % passo polare misurato in coil sides

kd1=sind((pi/(2*m1))/(q1*sind(pi/(2*m1*q1))));    % fattore di distribuzione

n=200;
ke=pi*sqrt(2)*pp/2*N_*phi_mg;
n_sec=n/60; %per calcolare la velocità in giri al secondo/Hz
kt=ke*m1/(2*pi);
EMF=ke*n_sec;
Td=kt*I_ph;
P_elm=n_sec*Td*pi*2;

%%
openfig('Grafico Ohm-rpm.fig')
set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
set(gcf, 'Color', 'w'); % Sfondo bianco della figura
box on; % Mantiene il bordo visibile


openfig('Grafico Potenza-rpm.fig')
set(gca, 'Color', 'w'); % Sfondo bianco dell'area del grafico
set(gcf, 'Color', 'w'); % Sfondo bianco della figura
box on; % Mantiene il bordo visibile
