const
  TiltAngle = 20.0; // Angolo di inclinazione in gradi
   
var
  Board: IPCB_Board;
  Track: IPCB_Track;
  CenterX, CenterY, Radius: TCoord;
  AngleStep, Angle, RadAngle, TiltRadAngle: Double;
  NumTracks, i: Integer;
  Length, Thickness: TCoord;
  X1, Y1, X2, Y2: TCoord;
begin
  Board := PCBServer.GetCurrentPCBBoard;
  if Board = nil then Exit;

  NumTracks := 480; // Numero di segmenti da creare
  AngleStep := 360.0 / NumTracks;
  CenterX := MilsToCoord(0);
  CenterY := MilsToCoord(0);
  Radius := MilsToCoord(3779.53);
  Length := MilsToCoord(629.921);
  Thickness := MilsToCoord(39.33858);

  for i := 0 to NumTracks - 1 do
  begin
    Angle := i * AngleStep;
    RadAngle := Angle * Pi / 180.0;
    TiltRadAngle := (Angle + TiltAngle) * Pi / 180.0; // Aggiungi inclinazione

    // Calcoliamo il punto iniziale della traccia
    X1 := CenterX + Round(Cos(TiltRadAngle) * Radius - (Length / 2) * Cos(TiltRadAngle));
    Y1 := CenterY + Round(Sin(TiltRadAngle) * Radius - (Length / 2) * Sin(TiltRadAngle));
    X2 := X1 + Round(Length * Cos(TiltRadAngle));
    Y2 := Y1 + Round(Length * Sin(TiltRadAngle));

    // Creiamo la traccia correttamente SENZA casting
    Track := PCBServer.PCBObjectFactory(eTrackObject, eNoDimension, eCreate_Default);
    if Track = nil then Continue;

    Track.X1 := X1;
    Track.Y1 := Y1;
    Track.X2 := X2;
    Track.Y2 := Y2;
    Track.Width := Thickness;
    Track.Layer := eTopLayer;

    Board.AddPCBObject(Track);
  end;

  PCBServer.PostProcess;
  Board.ViewManager_FullUpdate;
end;

