procedure CreateTracksAroundCircle;
var
  Board: IPCB_Board;
  Track: IPCB_Track;
  CenterX, CenterY, Radius: TCoord;
  AngleStep, Angle, RadAngle: Double;
  NumTracks, i: Integer;
  Length, Thickness: TCoord;
  X1, Y1, X2, Y2: TCoord;
begin
  Board := PCBServer.GetCurrentPCBBoard;
  if Board = nil then Exit;

  NumTracks := 480; // Numero di segmenti da creare
  AngleStep := 360.0 / NumTracks;
  CenterX := MilsToCoord(0); // Centro X della circonferenza
  CenterY := MilsToCoord(0); // Centro Y della circonferenza
  Radius := MilsToCoord(1673.228); // Raggio della circonferenza (35 mm)
  Length := MilsToCoord(590.551);  // Lunghezza del segmento (es. 15 mm)
  Thickness := MilsToCoord(11.8); // Spessore della traccia (es. 0.3 mils)

  for i := 0 to NumTracks - 1 do
  begin
    Angle := i * AngleStep;
    RadAngle := Angle * Pi / 180.0;

    // Calcoliamo il punto iniziale della traccia
    X1 := CenterX + Round(Cos(RadAngle) * Radius - (Length / 2) * Cos(RadAngle));
    Y1 := CenterY + Round(Sin(RadAngle) * Radius - (Length / 2) * Sin(RadAngle));
    X2 := X1 + Round(Length * Cos(RadAngle));
    Y2 := Y1 + Round(Length * Sin(RadAngle));

    // Creiamo la traccia correttamente SENZA casting
    Track := PCBServer.PCBObjectFactory(eTrackObject, eNoDimension, eCreate_Default);
    if Track = nil then Continue;

    Track.X1 := X1;
    Track.Y1 := Y1;
    Track.X2 := X2;
    Track.Y2 := Y2;
    Track.Width := Thickness;
    Track.Layer := eTopLayer; // Imposta il layer (es. Top Layer)

    Board.AddPCBObject(Track);
  end;

  PCBServer.PostProcess;
  Board.ViewManager_FullUpdate;
end;

begin
  CreateTracksAroundCircle;
end.


