
#include "stm32f303xe.h"	// valid for F303 MCU

int abilita_trasmissione;

int posizione_vettore_usart=0;
char data_output_vector[20];  // vettore per i dati a 8 bit

void write_data_output_vector(float num_float);

void VS_simpleP36_1f( float var1)

{

	data_output_vector[0]=0x55;
	posizione_vettore_usart=1;

	write_data_output_vector(var1);

	DMA1_Channel7->CCR&=(~(1<<0)); //DMA7 channel disable
	DMA1_Channel7->CNDTR=posizione_vettore_usart; // numero di dati da trasferire
	DMA1_Channel7->CCR|=(1<<0); //DMA7 channel enable
	
}


void VS_simpleP36_2f( float var1, float var2)

{

	data_output_vector[0]=0x55;
	posizione_vettore_usart=1;

	write_data_output_vector(var1);
	write_data_output_vector(var2);

	DMA1_Channel7->CCR&=(~(1<<0)); //DMA7 channel disable
	DMA1_Channel7->CNDTR=posizione_vettore_usart; // numero di dati da trasferire
	DMA1_Channel7->CCR|=(1<<0); //DMA7 channel enable
		
}


void VS_simpleP36_3f( float var1, float var2, float var3)

{

	data_output_vector[0]=0x55;
	posizione_vettore_usart=1;

	write_data_output_vector(var1);
	write_data_output_vector(var2);
	write_data_output_vector(var3);

	DMA1_Channel7->CCR&=(~(1<<0)); //DMA7 channel disable
	DMA1_Channel7->CNDTR=posizione_vettore_usart; // numero di dati da trasferire
	DMA1_Channel7->CCR|=(1<<0); //DMA7 channel enable
		
}

void VS_simpleP36_4f( float var1, float var2, float var3, float var4)

{

	data_output_vector[0]=0x55;
	posizione_vettore_usart=1;

	write_data_output_vector(var1);
	write_data_output_vector(var2);
	write_data_output_vector(var3);
	write_data_output_vector(var4);

	DMA1_Channel7->CCR&=(~(1<<0)); //DMA7 channel disable
	DMA1_Channel7->CNDTR=posizione_vettore_usart; // numero di dati da trasferire
	DMA1_Channel7->CCR|=(1<<0); //DMA7 channel enable
		
}

void VS_simpleP36_Init(void )
{
	
	////////////////////////////////////////////////////SET_UP_USART TO ST-LINK//////////////////////////////////////////////////////
	//USART2
	//PA3  -> USART-RX
	//PA2  ->	USART-TX
	RCC->APB1ENR|=1<<17; 					// abilito clock usart 2
	//Attivo i pin relativi all'usart	
	GPIOA->MODER&=(~(3<<(3*2)));
	GPIOA->MODER|=(2<<(3*2));  		// imposto alternate function su PA3
	GPIOA->MODER&=(~(3<<(2*2)));
	GPIOA->MODER|=(2<<(2*2));  		// imposto alternate function su PA2
	//selezione l'alternate function
	GPIOA->AFR[0]&= (~15<<(3*4));
	GPIOA->AFR[0]	|= (7<<(3*4));  // imposto AF7 su PA3 Rx
	GPIOA->AFR[0]&= (~15<<(2*4));
	GPIOA->AFR[0]|= (7<<(2*4));  	// imposto AF7 su PA2 Tx

	//fclk_periferica/(16*brr) fclk=32MHz
	USART2->CR1|=1<<2; 					 //recive enable 
	USART2->CR1|=1<<3; 					 //transmission enable
	USART2->BRR|=1<<4;					 //mantissa
	//USART2->BRR|=2<<4; 				 //mantissa	
	USART2->BRR|=0; 						 //parte frazionale
	USART2->CR1|=1<<0; 					 //usart enable

///////////////////////////////////////////////////SET_UP_DMA//////////////////////////////////////////////////////////////////////

  RCC->AHBENR|=1<<0; 																				//abilito clock DMA1
	DMA1->ISR|=0;
	DMA1_Channel7->CCR|=(1<<4); 															// data direction 1 ovvero read from memory
	DMA1_Channel7->CPAR= ( (uint32_t) (&(USART2->TDR)));  		//indirizzo periferica 
	DMA1_Channel7->CMAR= (uint32_t)(&data_output_vector[0]); 	// indirizzo memoria
	
	DMA1_Channel7->CCR|=(1<<7); 															// imposto memory increment mode 
	
	USART2->CR3|=(1<<7); 																			//abilito DMA USART 2 per la trasmissione
	
}






void float_two_char( float num_float, char *x1, char *x2, char *x3 ,char *x4)
{

	int num_int;

	num_int=*(int*)&num_float;

	*x1=((num_int>>24)&	0xff); // ultimi 8 bit MSB
	*x2=((num_int>>16)&	0xff);
	*x3=((num_int>>8)	&	0xff); 
	*x4=((num_int)		&	0xff); //primi otto LSB
	
}

void write_data_output_vector(float num_float)
{
	extern char data_output_vector[]; //vettore uscite
	extern int posizione_vettore_usart;//posizione nel vettore
	//la funzione prende il float a 32bit e lo spezza in 3 char a 8 bit e impila tutto nel vettore
	float_two_char(  num_float, &data_output_vector[posizione_vettore_usart+3], &data_output_vector[posizione_vettore_usart+2], &data_output_vector[posizione_vettore_usart+1] ,&data_output_vector[posizione_vettore_usart]);
	
	posizione_vettore_usart=posizione_vettore_usart+4;//4=32bit/8bit;
}




