#ifndef PSCOPE_H
#define PSCOPE_H


#define DMA_RX DMA1_Channel6
#define DMA_RX_STREAM_N 6
#define DMA_TX DMA1_Channel7
#define DMA_TX_STREAM_N 7


#define USART_PS1 USART2


#define N_variables_max_trace_h 50
#define N_elements_data_in_vector 10
#define N_elements_data_out_vector 20





typedef struct{

	unsigned int data_in_vector[N_elements_data_in_vector];
	unsigned int N_data_in;

	float data_out_vector[N_elements_data_out_vector];
	unsigned int N_data_out;

	unsigned char State_in;

	float* all_variables_address [N_variables_max_trace_h];
	float* out_variables_address [N_elements_data_out_vector];

	unsigned int N_out_variables;


	unsigned char flag_out_streaming_eable;
	unsigned int DMA_NDTR_out;
	unsigned int downsampling;
} pScope_handler_typedef;






void pScope_init(void);
void pScope_task(void);




#endif
