clear

% Variables
euro2dollar = 1.1754;           %USD (08-06-2018) European Central Bank
peso2dollar = 1/630;            %USD (08-06-2018) Banco Central de Chile
Cons_tariff = 0.1319;           %USD/kWh Energy consumed
Inj_tariff = 0.0751;            %USD/kWh Energy injected PMGD
Pcont_tariff = 18.5413;         %USD/kWh/month Conracted power
inflation = 0.03;               %Banco Central (mean)
disc_rate = 0.12;               %From study un commercial project, 166 kW
Perc_Wiring = 0.08;             %Perc of wiring costs over total
Perc_Inverters = 0.1;           %Perc of inverter and optimiers costs over total
Perc_Installation = 0.25;       %Perc of installation costs over total
Perc_Modules = 0.26;            %Perc of solar modules costs over total
Perc_Fastening = 0.3;           %Perc of Fastening system and ballasting costs over total
Perc_Studies = 0.01;            %Perc of Planning and paperwork costs over total

%%% Panels data
%Sun Shield --> Trina Solar TSM-300DD05A.08 (II)
P_max_Ssh = 300;                %Wp
gamma_p_Ssh = -0.0039;          %thermal coeff of max power (manufacturer)
NOCT_Ssh = 44;                  %C (Provided by manufacturer) 
Panel_length_Ssh = 0.992;       %m
Panel_width_Ssh = 1.65;         %m
Yearly_perf_reducion_Ssh = 1-(1-0.17)^(1/25); %From 97% to 80% en 25 years
Panelprice_Ssh_eur = 157;       %euro (from web)
Panelprice_Ssh_usd = 186.68;    %USD (from web)
Discount_wholesale = 0.1;
USDperW_Ssh_data = (1-Discount_wholesale)*Panelprice_Ssh_usd/P_max_Ssh; %USD/Wp
USDperW_Ssh = 0.45*euro2dollar; %USD/W (Becquerel Institute)

%Curtain Wall --> EnergyGlass Transparent and Opaque
P_max_Cwall_t = 130;            %Wp/m2, transparent
P_max_Cwall_o = 180;            %Wp/m2, opaque
gamma_p_Cwall = -0.004;         %thermal coeff
NOCT_Cwall = 44;                %C (Approx, not provided)
Yearly_perf_reducion_Cwall = 1-(1-0.25)^(1/30); %0.25/30; %25% in 30 years
Panelprice_Cwall_t_usd = 300*euro2dollar; %USD/m2
Panelprice_Cwall_o_usd = 240*euro2dollar; %USD/m2
USDperW_Cwall_t = 1.1*Panelprice_Cwall_t_usd/P_max_Cwall_t; %USD/Wp
USDperW_Cwall_o = 1.1*Panelprice_Cwall_o_usd/P_max_Cwall_o; %USD/Wp

%Inverter --> Sunny Tripower (SMA)
eff_DC2AC = 0.983;              %efficiency of power conversion
eff_MPPT = 0.999;               %efficiency of the MPPT
eff_inv = eff_DC2AC*eff_MPPT;   %efficiency of inverter
shad_losses = 0.98;             %Sading losses 
power_inv = 60;                 %kW
maintenance_inv = 0.0075;       %Source, paper Brasil
Inv_price_eur = 5088;           %eur (with delivery)

%System
effi = 0.92;    %total efficiency (wiring, dust, etc)
Ta = 25;        %C
Ta_NOCT = 20;   %C
G_NOCT = 800;   %W/m^2
G = 1000;       %W/m^2

%Building data
Building_depth = 48.74; %m
Building_width = 73.11; %m
N_floors = 12;
Building_height = N_floors*3.96; %m
FacadeArea = Building_width*Building_height; %m^2
WindowArea = FacadeArea*0.4;    %m^2
WallArea = FacadeArea*0.6;      %m^2

%%%Number of modules to use and P_rated
%Sun Shield
N_modFloor_Ssh = floor(Building_width/Panel_width_Ssh); %Hori
N_mod_Ssh = N_modFloor_Ssh*N_floors;                %N of modules used
Panel_Area_Ssh = Panel_length_Ssh*Panel_width_Ssh;  %m^2
Pmax_area_Ssh =P_max_Ssh/Panel_Area_Ssh;            %Wp/m^2
Total_area_Ssh = N_mod_Ssh*Panel_Area_Ssh;          %m^2
P_nom_Ssh = N_mod_Ssh*P_max_Ssh/1e3;                %kWp
%%% Sunpower (high efficiency m-Si)
% P_max_sunPower = 360;                               %Wp
% Area_sunPower = 1.558*1.046;                        %m^2
% Wper_m2_sunPower = P_max_sunPower/Area_sunPower;    %Wp/m^2
% P_nom_Ssh = N_mod_Ssh*Wper_m2_sunPower*Panel_Area_Ssh/1e3;  %kWp
%%% Jinko (lower efficiency)
% P_max_jinko = 265;                                  %Wp
% P_nom_Ssh = N_mod_Ssh*P_max_jinko/1e3;              %Wp/m^2

%Curtain Wall   
P_nom_Cwall_t = P_max_Cwall_t*WindowArea/1e3;       %kWp
P_nom_Cwall_o = P_max_Cwall_o*WallArea/1e3;         %kWp
P_nom_Cwall = P_nom_Cwall_t+P_nom_Cwall_o;          %kWp

%Roof (Same modules as Ssh)
N_modRow = floor(Building_width/Panel_width_Ssh); 
N_mod_Roof = 25*N_modRow;	%25 rows according to simulation
Total_area_Roof = N_mod_Roof*Panel_Area_Ssh; %m^2
P_nom_Roof = N_mod_Roof*P_max_Ssh/1e3;       %kWp
%%%% High efficiency 
% P_nom_Roof = N_mod_Roof*Wper_m2_sunPower*Panel_Area_Ssh/1e3;  %kWp
% %%% Low efficiency
% P_nom_Roof = N_mod_Roof*P_max_jinko/1e3; %kWp

% Number of inverters
N_inv_Ssh = ceil((P_nom_Ssh+P_nom_Roof)/power_inv);
N_inv_Cwall = ceil((P_nom_Cwall+P_nom_Roof)/power_inv); 


%%% Intial costs

Cost_Ssh_panels = USDperW_Ssh*P_nom_Ssh*1e3;                %USD
Cost_Cwall_t_panels = WindowArea*Panelprice_Cwall_t_usd*1.1;%USD (10% shipping)
Cost_Cwall_o_panels = WallArea*Panelprice_Cwall_o_usd*1.1;	%USD (10% shipping)
Cost_Cwall_panels = Cost_Cwall_t_panels+Cost_Cwall_o_panels;%USD
Cost_Roof_panels = USDperW_Ssh*P_nom_Roof*1e3;              %USD
USDperW_Cwall = (Cost_Cwall_panels/1.1)/(P_nom_Cwall*1e3);  %USD/W


InvertPerW_Ssh = 0.07*euro2dollar;
Cost_inv_Ssh = InvertPerW_Ssh*P_nom_Ssh*1e3;                    %USD
Cost_inv_Cwall = N_inv_Cwall*Inv_price_eur*euro2dollar;         %USD
Cost_inv_Roof = InvertPerW_Ssh*P_nom_Roof*1e3;                  %USD

WiringPerW_Ssh = 0.07*euro2dollar;                              %USD/W (Becquerel Institute)
WiringPerW_Cwall = USDperW_Cwall*(Perc_Wiring/Perc_Modules);    %USD/W
InstPerW_Ssh = 0.13*euro2dollar;                                %USD/W (Becquerel Institute)
InstPerW_Cwall = USDperW_Cwall*(Perc_Installation/Perc_Modules);%USD/W
FastenPerW = USDperW_Cwall*(Perc_Fastening/Perc_Modules);       %USD/W
MountPerW_Ssh = 0.07*euro2dollar;                               %USD/W (Becquerel Institute)
StudiesPerW_Ssh = 0.02*euro2dollar;                             %USD/W (Becquerel Institute)
StudiesPerW_Cwall = USDperW_Cwall*(Perc_Studies/Perc_Modules);  %USD/W
MarginPerW_Ssh = 0.14*euro2dollar;                              %USD/W (Becquerel Institute)

Cost_Wiring_Ssh = P_nom_Ssh*WiringPerW_Ssh*1e3;                 %USD
Cost_Wiring_Cwall = P_nom_Cwall*WiringPerW_Cwall*1e3;           %USD
Cost_Wiring_Roof = P_nom_Roof*WiringPerW_Ssh*1e3;               %USD
Cost_Inst_Ssh = P_nom_Ssh*InstPerW_Ssh*1e3;                     %USD
Cost_Inst_Cwall = P_nom_Cwall*InstPerW_Cwall*1e3;               %USD
Cost_Inst_Roof = P_nom_Roof*InstPerW_Ssh*1e3;                   %USD
Cost_Mount_Ssh = P_nom_Ssh*MountPerW_Ssh*1e3;                   %USD
Cost_Fasten_Cwall = P_nom_Cwall*FastenPerW*1e3;                 %USD
Cost_Mount_Roof = P_nom_Roof*MountPerW_Ssh*1e3;                 %USD
Cost_Studies_Ssh = P_nom_Ssh*StudiesPerW_Ssh*1e3;               %USD
Cost_Studies_Cwall = P_nom_Cwall*StudiesPerW_Cwall*1e3;         %USD
Cost_Studies_Roof = P_nom_Roof*StudiesPerW_Ssh*1e3;             %USD
Cost_Margin_Ssh = P_nom_Ssh*MarginPerW_Ssh*1e3;                 %USD
Cost_Margin_Roof = P_nom_Roof*MarginPerW_Ssh*1e3;               %USD

InitialCost_Ssh = Cost_Ssh_panels+Cost_inv_Ssh+Cost_Wiring_Ssh...
    +Cost_Inst_Ssh+Cost_Mount_Ssh+Cost_Studies_Ssh+Cost_Margin_Ssh;    %USD
InitialCost_Cwall = Cost_Cwall_panels+Cost_inv_Cwall+Cost_Wiring_Cwall...
    +Cost_Inst_Cwall+Cost_Fasten_Cwall+Cost_Studies_Cwall;             %USD
InitialCost_Roof = Cost_Roof_panels+Cost_inv_Roof+Cost_Wiring_Roof...
    +Cost_Inst_Roof+Cost_Mount_Roof+Cost_Studies_Roof+Cost_Margin_Roof;%USD


%%% Initial Savings

SavIni_win_Cwall = Cost_Cwall_panels/3;
SavIni_inst_Cwall = Cost_Inst_Cwall*0.4;
SavIni_fastening_Cwall = Cost_Fasten_Cwall*0.4;
InitialSavings_Cwall = SavIni_win_Cwall+SavIni_inst_Cwall+SavIni_fastening_Cwall;

%%% Fixed costs
%Cleaning cost/m2
cleanM2 = 20; %USD/m2
% % % Cleaning windows/facade
Cost_Cleaning_Ssh_ini = cleanM2*Total_area_Ssh*0.5;     %USD
Cost_Cleaning_Roof_ini = cleanM2*Total_area_Roof*0.5;	%USD
% % % Only consider the area that is not windows for the additional
% % % cleaning  cost
Cost_Cleaning_Cwall_ini = WallArea*cleanM2;             %USD
%Assuming cleanning every 2 months in summer semester and in winter with 
%the rain
n = 3;
Cost_Cleaning_Ssh = Cost_Cleaning_Ssh_ini*n;            %USD annual
Cost_Cleaning_Roof = Cost_Cleaning_Roof_ini*n;          %USD annual
Cost_Cleaning_Cwall = Cost_Cleaning_Cwall_ini*n;        %USD annual
%Costs for the next 25 years in both cases add the Roof costs
YearCleaning_Ssh = zeros(1,25);
YearCleaning_Roof = zeros(1,25);
YearCleaning_Cwall = zeros(1,25);
for i = 1:25
    YearCleaning_Ssh(i) = (Cost_Cleaning_Ssh+Cost_Cleaning_Roof)...
        *(1+inflation)^(i-1);
    YearCleaning_Cwall(i) = (Cost_Cleaning_Cwall+Cost_Cleaning_Roof)...
        *(1+inflation)^(i-1);
    YearCleaning_Roof(i) = Cost_Cleaning_Roof*(1+inflation)^(i-1);
end

%Define function for Tc
T_c_Ssh = @(x,y) x+(NOCT_Ssh-Ta_NOCT)*y/G_NOCT;
T_c_Cwall = @(x,y) x+(NOCT_Cwall-Ta_NOCT)*y/G_NOCT;
%Define function for P_ac:
P_ac_Ssh = @(x,y) P_nom_Ssh*(x/G)*effi*eff_inv*shad_losses*...
    (1+gamma_p_Ssh*(y-Ta));
% For Cwall 6% and 8% (transparent and opaque)increase because of Bifacial 
P_ac_Cwall_t = @(x,y) P_nom_Cwall_t*(x/G)*effi*eff_inv*shad_losses*...
    (1+gamma_p_Cwall*(y-Ta))*1.06;
P_ac_Cwall_o = @(x,y) P_nom_Cwall_o*(x/G)*effi*eff_inv*shad_losses*...
    (1+gamma_p_Cwall*(y-Ta))*1.08;
P_ac_Roof = @(x,y) P_nom_Roof*(x/G)*effi*eff_inv*shad_losses*...
    (1+gamma_p_Ssh*(y-Ta));
%Define function for Elec_dem:
Elec_dem = @(x) x/(3.6*1e6);

% Load file
D = readtable('DHC_E_I1MNWP.csv');
%Create timetable
DD = table2timetable(D);

%Determine if timetable is regular (same time differences)
tf = isregular(DD);
%Remove times with missing data
DD = rmmissing(DD);

%Yearly irradiation 
DD_rad = retime(DD(:,'ghi'),'yearly','sum');%W/m2
DD_rad.ghi = DD_rad.ghi/1e3;                %kW/m2

% % %Use 10 years and the mean of the values of: temp, ghi, dni, difh
Tamb_year = DD(ismember(year(DD.Fecha_Hora),2015),'temp');
Tamb_year.Properties.VariableNames{'temp'} = 'T_2015';
GHI_year = DD(ismember(year(DD.Fecha_Hora),2015),'ghi');
GHI_year.Properties.VariableNames{'ghi'} = 'GHI_2015';
DNI_year = DD(ismember(year(DD.Fecha_Hora),2015),'dni');
DNI_year.Properties.VariableNames{'dni'} = 'DNI_2015';
DIFh_year = DD(ismember(year(DD.Fecha_Hora),2015),'difh');
DIFh_year.Properties.VariableNames{'difh'} = 'DIFh_2015';
for i = 2006:2014
    temp1 = DD(ismember(year(DD.Fecha_Hora),i),'temp');
    todelete1 = (month(temp1.Fecha_Hora) == 2) & (day(temp1.Fecha_Hora) == 29);
    temp1(todelete1,:)=[];
    Tamb_year.New = temp1.Variables;
    Tamb_year.Properties.VariableNames{'New'} = strcat('T_',num2str(i));
    temp2 = DD(ismember(year(DD.Fecha_Hora),i),'ghi');
    todelete2 = (month(temp2.Fecha_Hora) == 2) & (day(temp2.Fecha_Hora) == 29);
    temp2(todelete2,:)=[];
    GHI_year.New = temp2.Variables;
    GHI_year.Properties.VariableNames{'New'} = strcat('GHI_',num2str(i));
    temp3 = DD(ismember(year(DD.Fecha_Hora),i),'dni');
    todelete3 = (month(temp3.Fecha_Hora) == 2) & (day(temp3.Fecha_Hora) == 29);
    temp3(todelete3,:)=[];
    DNI_year.New = temp3.Variables;
    DNI_year.Properties.VariableNames{'New'} = strcat('DNI_',num2str(i));
    temp4 = DD(ismember(year(DD.Fecha_Hora),i),'difh');
    todelete4 = (month(temp4.Fecha_Hora) == 2) & (day(temp4.Fecha_Hora) == 29);
    temp4(todelete4,:)=[];
    DIFh_year.New = temp4.Variables;
    DIFh_year.Properties.VariableNames{'New'} = strcat('DIFh_',num2str(i));
end
Mean10 = @(x1,x2,x3,x4,x5,x6,x7,x8,x9,x10) (x1+x2+x3+x4+x5+x6+x7+x8+x9+x10)/10;
Tamb_prom = rowfun(Mean10,Tamb_year,'OutputVariableNames','temp');
GHI_prom = rowfun(Mean10,GHI_year,'OutputVariableNames','ghi');
DNI_prom = rowfun(Mean10,DNI_year,'OutputVariableNames','dni');
DIFh_prom = rowfun(Mean10,DIFh_year,'OutputVariableNames','difh');
D_15 = [Tamb_prom GHI_prom DNI_prom DIFh_prom];

% % Calc in-plane irradiation
% Get the angle between beam and normal to module plane
tilt_Ssh = 33; %
tilt_Cwall = 90; %
% a = ghi, b = difh, c = dni
getTheta_Ssh = @(a,b,c) acosd((a-b)/c)-tilt_Ssh;
getTheta_Cwall = @(a,b,c) acosd((a-b)/c)-tilt_Cwall;
indNo0 = find(D_15.dni);
dniNon0 = D_15(D_15.Fecha_Hora(indNo0),:);
theta_Ssh = rowfun(getTheta_Ssh,dniNon0,'InputVariables',...
    {'ghi','difh','dni'},'OutputVariableNames','theta_Ssh');    %
theta_Cwall = rowfun(getTheta_Cwall,dniNon0,'InputVariables',...
    {'ghi','difh','dni'},'OutputVariableNames','theta_Cwall');  %
%Add  thetasto D_15
D_15 = synchronize(D_15,theta_Ssh,theta_Cwall,'union','fillwithconstant');
% Calc the irradiation Gt
% a = ghi, b = difh, c = dni, d = theta
G_t_Ssh = @(a,b,c,d) c*cosd(d)+b*0.5*(1+cosd(tilt_Ssh))+a*0.5*0.24*...
    (1-cosd(tilt_Ssh));
G_t_Cwall = @(a,b,c,d) c*cosd(d)+b*0.5*(1+cosd(tilt_Cwall))+a*0.5*0.24*...
    (1-cosd(tilt_Cwall));

Gt_Ssh = rowfun(G_t_Ssh,D_15,'InputVariables',...
    {'ghi','difh','dni','theta_Ssh'},'OutputVariableNames','Gt_Ssh');
Gt_Cwall = rowfun(G_t_Cwall,D_15,'InputVariables',...
    {'ghi','difh','dni','theta_Cwall'},'OutputVariableNames','Gt_Cwall');
%Add Gt to D_15
D_15 = [D_15 Gt_Ssh Gt_Cwall];

% % %Sensi: +/- 20% rad
% D_15.Gt_Ssh = D_15.Gt_Ssh*1.2;
% D_15.Gt_Cwall = D_15.Gt_Cwall*1.2;
% D_15.Gt_Ssh = D_15.Gt_Ssh*0.8;
% D_15.Gt_Cwall = D_15.Gt_Cwall*0.8;

% Calc Tc (Cell temperature)
Tc_Ssh = rowfun(T_c_Ssh,D_15,'InputVariables',{'temp','Gt_Ssh'},...
    'OutputVariableNames','Tc_Ssh');	%C
Tc_Cwall = rowfun(T_c_Cwall,D_15,'InputVariables',{'temp','Gt_Cwall'},...
    'OutputVariableNames','Tc_Cwall');	%C
% Add Tc to D_15
D_15 = [D_15 Tc_Ssh Tc_Cwall];

%Min Cell Temperature
Tamb_all = rowfun(T_c_Ssh,D_15,'InputVariables',{'temp','Gt_Ssh'},...
    'OutputVariableNames','Tc_all');	%C
Tamb_day = Tamb_all(ismember(hour(Tamb_all.Fecha_Hora),8:17),:);
[M,I] = min(Tamb_day.Tc_all);

% Calc Pac
Pac_Ssh_noR = rowfun(P_ac_Ssh,D_15,'InputVariables',...
    {'Gt_Ssh','Tc_Ssh'},'OutputVariableNames','Pac_Ssh_noR');       %kW
Pac_Cwall_t = rowfun(P_ac_Cwall_t,D_15,'InputVariables',...
    {'Gt_Cwall','Tc_Cwall'},'OutputVariableNames','Pac_Cwall_t');   %kW
Pac_Cwall_o = rowfun(P_ac_Cwall_o,D_15,'InputVariables',...
    {'Gt_Cwall','Tc_Cwall'},'OutputVariableNames','Pac_Cwall_o');   %kW                                                                       %kW
Pac_Roof = rowfun(P_ac_Roof,D_15,'InputVariables',...
    {'Gt_Ssh','Tc_Ssh'},'OutputVariableNames','Pac_Roof');          %kW
%Add the power of the roof to each case
Suma = @(x,y) x+y;
Pac_Cwall_noR = rowfun(Suma,[Pac_Cwall_t Pac_Cwall_o],...
    'OutputVariableNames','Pac_Cwall_noR'); %Transparent + Opaque
Pac_Ssh = rowfun(Suma,[Pac_Ssh_noR Pac_Roof],...
    'OutputVariableNames','Pac_Ssh');       %Ssh + Roof
Pac_Cwall = rowfun(Suma,[Pac_Cwall_noR Pac_Roof],...
    'OutputVariableNames','Pac_Cwall');     %Cwall + Roof

% Add Pac to DD
D_15 = [D_15 Pac_Ssh_noR Pac_Cwall_t Pac_Cwall_o Pac_Cwall_noR ...
    Pac_Roof Pac_Ssh Pac_Cwall];

% Demand profile
% Load file
B_base = readtable('Consumo_Ssh_Base.csv');
B_Ssh = readtable('Consumo_Ssh_HorizRoof.csv');
B_Cwall = readtable('Consumo_Cwall.csv');

%Create timetable
BB_base = table2timetable(B_base);
BB_Ssh = table2timetable(B_Ssh);
BB_Cwall = table2timetable(B_Cwall);

% Change year from 2009 to 2015 so it matches the year of the radiation
% data
BB_base.Hourly = BB_base.Hourly + calyears(6);   
BB_Ssh.Hourly = BB_Ssh.Hourly + calyears(6);
BB_Cwall.Hourly = BB_Cwall.Hourly + calyears(6);

%Use same hours as in irradiance data (fix first and last)
Bb_base = retime(BB_base,D_15.Fecha_Hora,'linear');
Bs_Ssh = retime(BB_Ssh,D_15.Fecha_Hora,'linear');
Bc_Cwall = retime(BB_Cwall,D_15.Fecha_Hora,'linear');

%Calculate demand in kWh
Bb_pow = rowfun(Elec_dem,Bb_base,'OutputVariableNames','Elec_dem_base');%kWh
Bs_pow = rowfun(Elec_dem,Bs_Ssh,'OutputVariableNames','Elec_dem_Ssh');  %kWh
Bc_pow = rowfun(Elec_dem,Bc_Cwall,'OutputVariableNames','Elec_dem_Cwall');%kWh

%Add Bx_pow to D_15
D_15 = [D_15 Bb_pow Bs_pow Bc_pow];

%%%% Simulation for the 25 wanted years %%%%
%%% Power gen
P_ac_Ssh_period = D_15(:,'Pac_Ssh');
P_ac_Cwall_period = D_15(:,'Pac_Cwall');
%Functions for the performance reduction of the panels over the yeras
Pac_Ssh_years = @(x) x*(1-Yearly_perf_reducion_Ssh);
Pac_Cwall_years = @(x) x*(1-Yearly_perf_reducion_Cwall);
%Assign name and include the downtime for the maintenace of the inverters
P_ac_Ssh_period.Properties.VariableNames = {'Pac_Ssh_1'};
P_ac_Ssh_period.Pac_Ssh_1 = P_ac_Ssh_period.Pac_Ssh_1*(1-maintenance_inv);
P_ac_Cwall_period.Properties.VariableNames = {'Pac_Cwall_1'};
P_ac_Cwall_period.Pac_Cwall_1=P_ac_Cwall_period.Pac_Cwall_1*(1-maintenance_inv);
 
%%% Power: Self-consumed vs Injected
Resta = @(x,y)  x-y;
DiffConsGen_Ssh = rowfun(Resta,D_15,'InputVariables',...
    {'Elec_dem_Ssh','Pac_Ssh'},'OutputVariableNames','DiffConsGen_Ssh_1');
DiffConsGen_Cwall = rowfun(Resta,D_15,'InputVariables',...
    {'Elec_dem_Cwall','Pac_Cwall'},'OutputVariableNames','DiffConsGen_Cwall_1');
%Calc of generated power for the next 25 years
for i = 2:25
   temp1 = rowfun(Pac_Ssh_years,P_ac_Ssh_period,'InputVariables',...
       {strcat('Pac_Ssh_',num2str(i-1))});
   P_ac_Ssh_period.New = temp1.Variables;
   P_ac_Ssh_period.Properties.VariableNames{'New'} =...
       strcat('Pac_Ssh_',num2str(i));
   
   temp2 = rowfun(Pac_Cwall_years,P_ac_Cwall_period,'InputVariables',...
       {strcat('Pac_Cwall_',num2str(i-1))});
   P_ac_Cwall_period.New = temp2.Variables;
   P_ac_Cwall_period.Properties.VariableNames{'New'} =...
       strcat('Pac_Cwall_',num2str(i));
   
   temp3 = rowfun(Resta,[D_15(:,'Elec_dem_Ssh'),temp1],...
       'OutputVariableNames',strcat('DiffConsGen_Ssh_',num2str(i)));
   DiffConsGen_Ssh.New = temp3.Variables;
   DiffConsGen_Ssh.Properties.VariableNames{'New'} =...
       strcat('DiffConsGen_Ssh_',num2str(i));
   
   temp4 = rowfun(Resta,[D_15(:,'Elec_dem_Cwall'),temp2],...
       'OutputVariableNames',strcat('DiffConsGen_Cwall_',num2str(i)));
   DiffConsGen_Cwall.New = temp4.Variables;
   DiffConsGen_Cwall.Properties.VariableNames{'New'} =...
       strcat('DiffConsGen_Cwall_',num2str(i));
end

%%% Demand not consumed when panels are installed
%Assuming consumption remains the same in the 25 years
EnotConsumed_Ssh = rowfun(Resta,D_15,'InputVariables',{'Elec_dem_base',...
    'Elec_dem_Ssh'},'OutputVariableNames','EnotConsumed_Ssh');
EnotC_Ssh_y = retime(EnotConsumed_Ssh,'yearly','sum');
EnotConsumed_Cwall = rowfun(Resta,D_15,'InputVariables',{'Elec_dem_base',...
    'Elec_dem_Cwall'},'OutputVariableNames','EnotConsumed_Cwall');
EnotC_Cwall_y = retime(EnotConsumed_Cwall,'yearly','sum');

%%% Maximum values of demand
Dmax_base = max(D_15.Elec_dem_base);
%Take data only of peak hours
Dpunta_h = Bb_pow(ismember(hour(Bb_pow.Hourly),18:23),:);
Dpunta_m = Dpunta_h(ismember(month(Dpunta_h.Hourly),4:9),:);
Dmedia_punta = retime(Dpunta_m,'daily','sum');
Dmedia_punta.Elec_dem_base = Dmedia_punta.Elec_dem_base/5;
Tp_base=max(Dmedia_punta.Elec_dem_base)/Dmax_base;

%For Ssh
Dmax_Ssh = max(DiffConsGen_Ssh.Variables);
%Take data only of peak hours
Dpunta_h_Ssh = DiffConsGen_Ssh(ismember(hour(DiffConsGen_Ssh.Fecha_Hora),18:23),:);
Dpunta_m_Ssh = Dpunta_h_Ssh(ismember(month(Dpunta_h_Ssh.Fecha_Hora),4:9),:);
Dmedia_punta_Ssh = retime(Dpunta_m_Ssh,'daily','sum');
Dmedia_punta_Ssh.Variables = Dmedia_punta_Ssh.Variables/5;
Tp_base_Ssh=max(Dmedia_punta_Ssh.Variables)./Dmax_Ssh;
D_peak = retime(D_15(:,'Elec_dem_base'),'daily',@max);
Dpunta2 = Bb_pow(ismember(D_15.Elec_dem_base,D_peak.Elec_dem_base),:);
%For Cwall
Dmax_Cwall = max(DiffConsGen_Cwall.Variables);

%%% Savings - Energy self-consumed and injected - Money

Zero = @(x) x*0;
Esavings_Ssh = varfun(Zero,P_ac_Ssh_period);
Esavings_Cwall = varfun(Zero,P_ac_Cwall_period);
YearlyEnotC_Ssh = zeros(1,25);
YearlyEnotC_Cwall = zeros(1,25);
YearlyPmaxChange_Ssh = zeros(1,25);
YearlyPmaxChange_Cwall = zeros(1,25);
Tcons = zeros(1,25);
Tinj = zeros(1,25);
Tcontr = zeros(1,25);
for i = 1:25
    Tcons(i) = Cons_tariff*(1+inflation)^(i-1);
    Tinj(i) = Inj_tariff*(1+inflation)^(i-1);
    Tcontr(i) = Pcont_tariff*(1+inflation)^(i-1);
    YearlyEnotC_Ssh(i) = EnotC_Ssh_y.Variables*Tcons(i);
    YearlyEnotC_Cwall(i) = EnotC_Cwall_y.Variables*Tcons(i);
    YearlyPmaxChange_Ssh(i) = (Dmax_base-Dmax_Ssh(i))*Tcontr(i)*12;
    YearlyPmaxChange_Cwall(i) = (Dmax_base-Dmax_Cwall(i))*Tcontr(i)*12;
end
%Matrix with 1 if positive (more consumption)
DiffPos_Ssh = DiffConsGen_Ssh.Variables;
DiffPos_Ssh(DiffPos_Ssh<0) = 0;
DiffPos_Ssh(DiffPos_Ssh>0) = 1;
DiffPos_Ssh = DiffPos_Ssh.*Tcons;
DiffPos_Ssh = DiffPos_Ssh.*P_ac_Ssh_period.Variables;
%matrix with 1 if negative (more generation)
DiffNeg_Ssh = DiffConsGen_Ssh.Variables;
DiffNeg_Ssh(DiffNeg_Ssh>0) = 0;
DiffNeg_Ssh(DiffNeg_Ssh<0) = 1;
DiffNeg_Ssh_cons = DiffNeg_Ssh.*Tcons;
DiffNeg_Ssh_inj = DiffNeg_Ssh.*Tinj;
DiffNeg_Ssh_cons = DiffNeg_Ssh_cons.*D_15.Elec_dem_Ssh;
DiffNeg_Ssh_inj = -DiffNeg_Ssh_inj.*DiffConsGen_Ssh.Variables;
Esavings_Ssh.Variables = DiffPos_Ssh+DiffNeg_Ssh_cons+DiffNeg_Ssh_inj;

%Matrix with 1 if positive (more consumption)
DiffPos_Cwall = DiffConsGen_Cwall.Variables;
DiffPos_Cwall(DiffPos_Cwall<0) = 0;
DiffPos_Cwall(DiffPos_Cwall>0) = 1;
DiffPos_Cwall = DiffPos_Cwall.*Tcons;
DiffPos_Cwall = DiffPos_Cwall.*P_ac_Cwall_period.Variables;
%matrix with 1 if negative (more generation)
DiffNeg_Cwall = DiffConsGen_Cwall.Variables;
DiffNeg_Cwall(DiffNeg_Cwall>0) = 0;
DiffNeg_Cwall(DiffNeg_Cwall<0) = 1;
DiffNeg_Cwall_cons = DiffNeg_Cwall.*Tcons;
DiffNeg_Cwall_inj = DiffNeg_Cwall.*Tinj;
DiffNeg_Cwall_cons = DiffNeg_Cwall_cons.*D_15.Elec_dem_Cwall;
DiffNeg_Cwall_inj = -DiffNeg_Cwall_inj.*DiffConsGen_Cwall.Variables;
Esavings_Cwall.Variables = DiffPos_Cwall+DiffNeg_Cwall_cons+DiffNeg_Cwall_inj;

YearEnergy_Ssh = retime(P_ac_Ssh_period,'yearly','sum');
YearSavings_Ssh = retime(Esavings_Ssh,'yearly','sum');
YearEnergy_Cwall = retime(P_ac_Cwall_period,'yearly','sum');
YearSavings_Cwall = retime (Esavings_Cwall,'yearly','sum');
YearEnergy_Roof = retime(D_15(:,'Pac_Roof'),'yearly','sum');
YearEnergy_Roof.Pac_Roof = YearEnergy_Roof.Pac_Roof*(1-maintenance_inv);
YearEnergy_SshNoR = retime(D_15(:,'Pac_Ssh_noR'),'yearly','sum');
YearEnergy_SshNoR.Pac_Ssh_noR = YearEnergy_SshNoR.Pac_Ssh_noR*(1-maintenance_inv);
YearEnergy_CwallNor = retime(D_15(:,'Pac_Cwall_noR'),'yearly','sum');
YearEnergy_CwallNor.Pac_Cwall_noR = YearEnergy_CwallNor.Pac_Cwall_noR*(1-maintenance_inv);


%%% Net present Value
%Cash flow for years 1 to 25
%Add initial costs and savings
CashFlow_Ssh = YearSavings_Ssh.Variables+YearlyEnotC_Ssh+YearlyPmaxChange_Ssh-YearCleaning_Ssh;
CashFlow_Ssh = [-InitialCost_Ssh-InitialCost_Roof CashFlow_Ssh];
CashFlow_Cwall = YearSavings_Cwall.Variables+YearlyEnotC_Cwall+YearlyPmaxChange_Cwall-YearCleaning_Cwall;
CashFlow_Cwall = [-InitialCost_Cwall-InitialCost_Roof+InitialSavings_Cwall CashFlow_Cwall];

NPV_Prueba_Ssh = pvvar(CashFlow_Ssh,disc_rate);
NPV_Prueba_Cwall = pvvar(CashFlow_Cwall,disc_rate);
IRR_Ssh = irr(CashFlow_Ssh);
IRR_Cwall = irr(CashFlow_Cwall);
NPV_Ssh = - InitialCost_Ssh-InitialCost_Roof;
disc_payback_Ssh = 0;
Sum_Ssh = 0;
payback_Ssh = 0;
NPV_Cwall = - InitialCost_Cwall-InitialCost_Roof+InitialSavings_Cwall;
disc_payback_Cwall = 0;
Sum_Cwall = 0;
payback_Cwall = 0;
for i = 1:25
    Sum_Ssh = Sum_Ssh+CashFlow_Ssh(i);
    if Sum_Ssh <0
        payback_Ssh = payback_Ssh+1;
    end
   if NPV_Ssh < 0
       disc_payback_Ssh = disc_payback_Ssh+1;
   end    
   NPV_Ssh = NPV_Ssh + (YearSavings_Ssh(:,i).Variables+YearlyEnotC_Ssh(i)+...
       YearlyPmaxChange_Ssh(i) - YearCleaning_Ssh(i))/(1+disc_rate)^(i); 
   
   Sum_Cwall = Sum_Cwall+CashFlow_Cwall(i);
    if Sum_Cwall <0
        payback_Cwall = payback_Cwall+1;
    end
   if NPV_Cwall < 0
       disc_payback_Cwall = disc_payback_Cwall+1;
   end
   NPV_Cwall = NPV_Cwall + (YearSavings_Cwall(:,i).Variables+YearlyEnotC_Cwall(i)+...
       YearlyPmaxChange_Cwall(i) - (YearCleaning_Cwall(i)))/(1+disc_rate)^(i); 
end

%%% LCOE
discE_Ssh = pvvar([0 YearEnergy_Ssh.Variables],disc_rate);                              %kWh
discCosts_Ssh = pvvar([InitialCost_Ssh+InitialCost_Roof YearCleaning_Ssh],disc_rate);   %USD
LCOE_Ssh = discCosts_Ssh/discE_Ssh;                                                     %USD/kWh
discE_Cwall = pvvar([0 YearEnergy_Cwall.Variables],disc_rate);
discCosts_Cwall = pvvar([InitialCost_Cwall+InitialCost_Roof-...
    InitialSavings_Cwall YearCleaning_Cwall],disc_rate);
LCOE_Cwall = discCosts_Cwall/discE_Cwall;

%%% Calc Anual Energy Yield
%Sun Shield
Tot_gen_Ssh = YearEnergy_Ssh.Pac_Ssh_1;                     %kWh/year
Tot_gen_SshNoR = YearEnergy_SshNoR.Pac_Ssh_noR;         	%kWh/year
%Curtain Wall
Tot_gen_Cwall = YearEnergy_Cwall.Pac_Cwall_1;               %kWh/year
Tot_gen_CwallNoR = YearEnergy_CwallNor.Pac_Cwall_noR;       %kWh/year
%%%Calc Specific yield
An_E_Yield_Ssh = Tot_gen_Ssh/(P_nom_Ssh+P_nom_Roof);        %kWh/kWp
An_E_Yield_SshNoR = Tot_gen_SshNoR/(P_nom_Ssh);             %kWh/kWp
An_E_Yield_Cwall = Tot_gen_Cwall/(P_nom_Cwall+P_nom_Roof);	%kWh/kWp
An_E_Yield_CwallNoR = Tot_gen_CwallNoR/(P_nom_Cwall);       %kWh/kWp
%%%Calc PR for thr year
Hi_Ssh = sum(D_15.Gt_Ssh);                                  %W/m2
Hi_Cwall = (sum(D_15.Gt_Cwall)*FacadeArea+sum(D_15.Gt_Ssh)*...
    Total_area_Roof)/(FacadeArea+Total_area_Roof);          %W/m2
Hi_CwallNoR = sum(D_15.Gt_Cwall);                           %W/m2
Yr_Ssh = Hi_Ssh/G;
Yr_Cwall = Hi_Cwall/G;
Yr_CwallNoR = Hi_CwallNoR/G;
PR_Ssh = Tot_gen_Ssh*G/(sum(D_15.Gt_Ssh)*(P_nom_Ssh+P_nom_Roof));	%An_E_Yield_Ssh/Yr_Ssh
PR_SshNoR = Tot_gen_SshNoR*G/(sum(D_15.Gt_Ssh)*(P_nom_Ssh));        %An_E_Yield_SshNoR/Yr_Ssh
PR_Cwall = An_E_Yield_Cwall/Yr_Cwall;
PR_CwallNoR = Tot_gen_CwallNoR*G/(sum(D_15.Gt_Cwall)*(P_nom_Cwall));%An_E_Yield_CwallNoR/Yr_CwallNoR

%%% PR every year
Yieldf_Ssh = @(x) x/(P_nom_Ssh+P_nom_Roof);
Yieldf_Cwall = @(x) x/(P_nom_Cwall+P_nom_Roof);
PerfRatio_Ssh = @(x) x/Yr_Ssh;
PerfRatio_Cwall = @(x) x/Yr_Cwall;
Yf_Ssh = varfun(Yieldf_Ssh, YearEnergy_Ssh);
Yf_Cwall = varfun(Yieldf_Cwall, YearEnergy_Cwall);
PRy_Ssh = varfun(PerfRatio_Ssh, Yf_Ssh);
PRy_Cwall = varfun(PerfRatio_Cwall, Yf_Cwall);
plot(1:25, PRy_Ssh.Variables)
hold on
plot(1:25, PRy_Cwall.Variables)
%Power gen over power consumed
Total_Dem_Ssh = retime(Bs_pow(:,'Elec_dem_Ssh'),'yearly','sum');
Total_Dem_Ssh = Total_Dem_Ssh.Elec_dem_Ssh;
Total_Dem_Cwall = retime(Bc_pow(:,'Elec_dem_Cwall'),'yearly','sum');
Total_Dem_Cwall = Total_Dem_Cwall.Elec_dem_Cwall;
PgenOPcons_Ssh = Tot_gen_Ssh/Total_Dem_Ssh;
PgenOPcons_SshNoR = Tot_gen_SshNoR/Total_Dem_Ssh;
PgenOPcons_Cwall = Tot_gen_Cwall/Total_Dem_Cwall;
PgenOPcons_CwallNoR = Tot_gen_CwallNoR/Total_Dem_Cwall;

%%  %%%%%%%%%%%%%
    %%% Plots %%%
    %%%%%%%%%%%%%
    
%%% Plot cash flows
%Ssh
cfDates = 0:25;
Invest_Ssh = zeros(1,26);
Invest_Ssh(1) = (-InitialCost_Ssh-InitialCost_Roof)*1e-3;
Fut_Cflows_Ssh =[0 YearSavings_Ssh.Variables+YearlyEnotC_Ssh+YearlyPmaxChange_Ssh-YearCleaning_Ssh]*1e-3;
figure
bar(cfDates,Invest_Ssh,'r')
hold on
bar(cfDates,Fut_Cflows_Ssh,'b')
ylim([-4500 500]);
title('Cash flows for the Sun shield configuration');
xlabel('Year');
ylabel('Cash flows, Thousand [USD]');
hold off

%Cwall
cfDates = 0:25;
Invest_Cwall = zeros(26,2);
Invest_Cwall(1,:) = [(-InitialCost_Cwall-InitialCost_Roof+...
    InitialSavings_Cwall)*1e-3 -(InitialSavings_Cwall)*1e-3];
Fut_Cflows_Cwall =[0 YearSavings_Cwall.Variables+YearlyEnotC_Cwall+YearlyPmaxChange_Cwall-YearCleaning_Cwall]*1e-3;
figure
h=bar(cfDates,Invest_Cwall,'stacked');
set(h,{'FaceColor'},{'r';'y'});
hold on
bar(cfDates,Fut_Cflows_Cwall,'b')
ylim([-4500 500]);
title('Cash flows for the Curtain wall configuration');
xlabel('Year');
ylabel('Cash flows, Thousand [USD]');
hold off

%Plot monthly global horizontal irradiance
D_15_rad = retime(D_15(:,'ghi'),'daily','sum'); %W/m2
D_15_rad.ghi = D_15_rad.ghi/1e3;                %kW/m2
D_15_rad_av = retime(D_15_rad,'monthly','mean');
D_15_rad_year = retime(D_15_rad, 'yearly','sum');
D_15_rad_year = D_15_rad_year.ghi;
figure
plot(D_15_rad_av.Fecha_Hora,D_15_rad_av.ghi,'-o','LineWidth',1)
ylim([0 9]);
title(strcat('Mean Global Horizontal Radiation in',{' '},string(year(D_15_rad_av.Fecha_Hora(1)))));
xlabel('Month');
ylabel('GHI [kWh/m^2/day]');
set(gca,'YGrid','on');

%Plot daily energy demand in the year
figure
% hold on
% plot(D_15.Fecha_Hora,D_15.Elec_dem_base)
plot(D_15.Fecha_Hora,D_15.Elec_dem_Ssh)
% plot(D_15.Fecha_Hora,D_15.Elec_dem_Cwall)
ylim([0 inf]);
title(strcat('Demand profile in',{' '},string(year(D_15.Fecha_Hora(1)))));
xlabel('Time[h]');
ylabel('Power consumed [kW]');
% hold off

% Plot daily energy production in the year
%Sun shield
figure
plot(D_15.Fecha_Hora,D_15.Pac_Ssh);
ylim([0 650]);
% title(strcat('Power generation in',{' '},string(year(D_15.Fecha_Hora(1))),', Sun shield'));
title(strcat('Power generation in a year, Sun shield'));
set(gca,'YGrid','on'); 
xlabel('Time[h]');
ylabel('Power produced [kW]');
%Curtain wall
figure
plot(D_15.Fecha_Hora,D_15.Pac_Cwall);
ylim([0 650]);
% title(strcat('Power generation in',{' '},string(year(D_15.Fecha_Hora(1))),', Curtain wall'));
title(strcat('Power generation in a year, Curtain wall'));
set(gca,'YGrid','on'); 
xlabel('Time[h]');
ylabel('Power produced [kW]');
% Plot daily cell temperature in the year
figure
plot(D_15.Fecha_Hora,D_15.Tc_Ssh);
title(strcat('Cell temperature in',{' '},string(year(D_15.Fecha_Hora(1))),', Sun shield'));
xlabel('Time[h]');
ylabel('Tc [C]');
figure
plot(D_15.Fecha_Hora,D_15.Tc_Cwall);
title(strcat('Cell temperature in',{' '},string(year(D_15.Fecha_Hora(1))),', Curtain wall'));
xlabel('Time[h]');
ylabel('Tc [C]');

%Plot one day
dia = datetime(2015,7,16); %Choose day
Tr_dia = timerange(dia,dia+days(1)-minutes(1));
D_1 = D_15(Tr_dia,:);
%%% Power generation
%Sun shield
figure
plot(D_1.Fecha_Hora,D_1.Pac_Ssh,'-o','LineWidth',1);
title(strcat('Hourly generation in',{' '},string(month(D_1.Fecha_Hora(1),'name')),{', '},string(year(D_1.Fecha_Hora(1))),', Sun shield'));
xlabel('Time [hh:mm]');
ylabel('Power produced [kW]');
xticks(D_1.Fecha_Hora(1):hours(3):D_1.Fecha_Hora(end));
set(gca,'XGrid','on'); 
%Curtain wall
figure
plot(D_1.Fecha_Hora,D_1.Pac_Cwall,'-o','LineWidth',1);
title(strcat('Hourly generation in',{' '},string(month(D_1.Fecha_Hora(1),'name')),{', '},string(year(D_1.Fecha_Hora(1))),', Curtain wall'));
xlabel('Time [hh:mm]');
ylabel('Power produced [kW]');
xticks(D_1.Fecha_Hora(1):hours(3):D_1.Fecha_Hora(end));
set(gca,'XGrid','on'); 
%%% Energy demand
figure
plot(D_1.Fecha_Hora,D_1.Elec_dem_Ssh,'-o','LineWidth',1);
ylim([0 inf]);
title(strcat('Hourly demand in',{' '},string(month(D_1.Fecha_Hora(1),'name')),{', '},string(year(D_1.Fecha_Hora(1)))));
xlabel('Time [hh:mm]');
ylabel('Energy demand [kW]');
xticks(D_1.Fecha_Hora(1):hours(3):D_1.Fecha_Hora(end));
set(gca,'XGrid','on'); 
% Cell temperature
%Ssh
figure
plot(D_1.Fecha_Hora,D_1.Tc_Ssh,'-o','LineWidth',1);
title(strcat('Hourly cell temperature (Sun shield) in',{' '},string(month(D_1.Fecha_Hora(1),'name')),{', '},string(year(D_1.Fecha_Hora(1)))));
xlabel('Time [hh:mm]');
ylabel('Tc [C]');
xticks(D_1.Fecha_Hora(1):hours(3):D_1.Fecha_Hora(end));
set(gca,'XGrid','on');
%Cwall
figure
plot(D_1.Fecha_Hora,D_1.Tc_Cwall,'-o','LineWidth',1);
title(strcat('Hourly cell temperature (curtain wall) in',{' '},string(month(D_1.Fecha_Hora(1),'name')),{', '},string(year(D_1.Fecha_Hora(1)))));
xlabel('Time [hh:mm]');
ylabel('Tc [C]');
xticks(D_1.Fecha_Hora(1):hours(3):D_1.Fecha_Hora(end));
set(gca,'XGrid','on');

%%% Plot both Pac and Tc
%Ssh
figure
yyaxis left
plot(D_1.Fecha_Hora,D_1.Gt_Ssh,'-o','LineWidth',1);
xlabel('Time [hh:mm]');
ylabel({'In-Plane Irradiance [W/m^2]';'\color{green}Power Sun shield [kW], *'...%;'\color{black}Demand [kW]'
    });
xticks(D_1.Fecha_Hora(1):hours(3):D_1.Fecha_Hora(end));
ylim([0 1100]);
set(gca,'XGrid','on'); 
hold on
plot(D_1.Fecha_Hora,D_1.Pac_Ssh,'-*','LineWidth',1,'Color','g');
% plot(D_1.Fecha_Hora,D_1.Elec_dem_Ssh,'-o','LineWidth',1,'Color','black');
% plot(D_1.Fecha_Hora,D_1.Elec_dem_base,'-o','LineWidth',1,'Color','r');
yyaxis right
% plot(D_1.Fecha_Hora,D_1.temp,'-o','LineWidth',1);
plot(D_1.Fecha_Hora,D_1.Tc_Ssh,'-o','LineWidth',1 ...%,'Color','m'
);
ylabel({...%'Tamb [C]';'\color{magenta}
    'Tc [C]'});
ylim([0 60]);
hold off
%Cwall
figure
yyaxis left
plot(D_1.Fecha_Hora,D_1.Gt_Cwall,'-o','LineWidth',1);
xlabel('Time [hh:mm]');
ylabel({'In-Plane Irradiance [W/m^2]';'\color{green}Power Curtain wall [kW], *';...%'\color{black}Demand [kW]'
    });
xticks(D_1.Fecha_Hora(1):hours(3):D_1.Fecha_Hora(end));
ylim([0 800]);
set(gca,'XGrid','on'); 
hold on
plot(D_1.Fecha_Hora,D_1.Pac_Cwall,'-*','LineWidth',1,'Color','g');
% plot(D_1.Fecha_Hora,D_1.Elec_dem_Cwall,'-o','LineWidth',1,'Color','black');
% plot(D_1.Fecha_Hora,D_1.Elec_dem_base,'-o','LineWidth',1,'Color','black');
yyaxis right
% plot(D_1.Fecha_Hora,D_1.temp,'-o','LineWidth',1);
plot(D_1.Fecha_Hora,D_1.Tc_Cwall,'-o','LineWidth',1);
ylabel({...%'Tamb [C]';\color{magenta}
    'Tc [C]'});
ylim([0 50]);
hold off

%%%Plot total monthly production of the year
%Ssh
temp_1 = P_ac_Ssh_period(:,'Pac_Ssh_1');
temp_25 = P_ac_Ssh_period(:,'Pac_Ssh_25');
D_15mp_1 = retime(temp_1,'monthly','sum');
D_15mp_25 = retime(temp_25,'monthly','sum');
calcK = @(x) x/1e3;
D_15mk_1 = rowfun(calcK,D_15mp_1,'OutputVariableNames','Pac_Ssh_1');%MW
D_15mk_25 = rowfun(calcK,D_15mp_25,'OutputVariableNames','Pac_Ssh_25');%MW
figure
plot(D_15mk_1.Fecha_Hora,D_15mk_1.Pac_Ssh_1,'-o','LineWidth',1);
hold on
plot(D_15mk_25.Fecha_Hora,D_15mk_25.Pac_Ssh_25,'-*','LineWidth',1,'color','black');
title(strcat('Total monthly generation (Sun shield),',{' '},...
    string(year(D_15mk_1.Fecha_Hora(1))),'-',string(year(D_15mk_1.Fecha_Hora(1))+24)));
xlabel('Month');
ylabel('Energy produced [MWh]');
ylabel({'\color{lightblue}Total Energy 2015 [MWh]';'\color{black}Total Energy 2039 [MWh], *'});
ylim([0 200]);
set(gca,'XGrid','on');
hold off
%Cwall
temp = P_ac_Cwall_period(:,'Pac_Cwall_1');
temp_25 = P_ac_Cwall_period(:,'Pac_Cwall_25');
D_15mp = retime(temp,'monthly','sum');
D_15mp_25 = retime(temp_25,'monthly','sum');
calcK = @(x) x/1e3;
D_15mk = rowfun(calcK,D_15mp,'OutputVariableNames','Pac_Cwall_1');
D_15mk_25 = rowfun(calcK,D_15mp_25,'OutputVariableNames','Pac_Cwall_25');%MW
figure
plot(D_15mk.Fecha_Hora,D_15mk.Pac_Cwall_1,'-o','LineWidth',1);
hold on
plot(D_15mk_25.Fecha_Hora,D_15mk_25.Pac_Cwall_25,'-*','LineWidth',1,'color','black');
title(strcat('Total monthly generation (Curtain wall),',{' '},...
    string(year(D_15mk.Fecha_Hora(1))),'-',string(year(D_15mk_1.Fecha_Hora(1))+24)));
xlabel('Month');
ylabel({'\color{lightblue}Total Energy 2015 [MWh]';'\color{black}Total Energy 2039 [MWh], *'});
ylim([0 200]);
set(gca,'XGrid','on');
hold off

%Plot total monthly demand of the year
temp = D_15(:,'Elec_dem_base');
D_15d = retime(temp,'monthly','sum');
D_15dm = rowfun(calcK,D_15d,'OutputVariableNames','Elec_dem_base');
figure
plot(D_15dm.Fecha_Hora,D_15dm.Elec_dem_base,'-o','LineWidth',1);
title(strcat('Total monthly demand,',{' '},string(year(D_15dm.Fecha_Hora(1)))));
xlabel('Month');
ylabel('Demand [MW]');
ylim([0 inf]);
set(gca,'XGrid','on');

%%%Plot monthly mean Tc on the year
%Ssh
temp = D_15(:,'Tc_Ssh');
D_15mt = retime(temp,'monthly','mean');
figure
plot(D_15mt.Fecha_Hora,D_15mt.Tc_Ssh,'-o','LineWidth',1);
title(strcat('Mean cell temperature (Sun shield),',{' '},string(year(D_15mt.Fecha_Hora(1)))));
xlabel('Month');
ylabel('Tc [C]');
ylim([0 inf]);
set(gca,'XGrid','on');
%Cwall
temp = D_15(:,'Tc_Cwall');
D_15mt = retime(temp,'monthly','mean');
figure
plot(D_15mt.Fecha_Hora,D_15mt.Tc_Cwall,'-o','LineWidth',1);
title(strcat('Mean cell temperature (Curtain wall),',{' '},string(year(D_15mt.Fecha_Hora(1)))));
xlabel('Month');
ylabel('Tc [C]');
ylim([0 inf]);
set(gca,'XGrid','on');

%Plot Demand vs GenDem in two different weeks 
% 16 jan y 17 jul
%Ssh
t = datetime(2015,7,17);
tr = timerange(t,t+caldays(7)-minutes(1));
D_sem = D_15(tr,:);
Diff_sem = DiffConsGen_Ssh(tr,:);
figure;
iptsetpref('ImshowAxesVisible','on');
hold on;
plot(Diff_sem.Fecha_Hora,Diff_sem.DiffConsGen_Ssh_1,'LineWidth',1,'Color','b');
plot(D_sem.Fecha_Hora,D_sem.Pac_Ssh,'Color','g');
plot(D_sem.Fecha_Hora,D_sem.Elec_dem_Ssh,'Color','r');
yticks(-100:100:1100)
ylim([-100 1100]);
title(strcat(month(t,'name'),{' '}, string(year(t)),{', Sun shield'}));
ylabel({'\color{green}Energy produced [kWh]';'\color{blue}Effective demand [kWh]';'\color{red}Energy demand [kWh]'});
ax = gca;
ax.XAxisLocation = 'origin';

%Cwall
Diff_sem = DiffConsGen_Cwall(tr,:);
figure1 = figure;
iptsetpref('ImshowAxesVisible','on');
hold on;
plot(Diff_sem.Fecha_Hora,Diff_sem.DiffConsGen_Cwall_1,'LineWidth',1,'Color','b');
plot(D_sem.Fecha_Hora,D_sem.Pac_Cwall,'Color','g');
plot(D_sem.Fecha_Hora,D_sem.Elec_dem_Cwall,'Color','r');
yticks(-300:100:1100)
ylim([-300 1100]);
title(strcat(month(t,'name'),{' '}, string(year(t)),{', Curtain wall'}));
ylabel({'\color{green}Energy produced [kWh]';'\color{blue}Effective demand [kWh]';'\color{red}Energy demand [kWh]'});
ax = gca;
ax.XAxisLocation = 'origin';


%%
%Plot production for each month
for i = 1:12
    t = datetime(2015,i,1);
    tr = timerange(t,t+calmonths(1)-minutes(1));
    D_i = D_15(tr,:);
    Diff_i = DiffConsGen_Ssh(tr,:);
    Diff2_i = DiffConsGen_Cwall(tr,:);
    %Ssh
    figure1 = figure;
    iptsetpref('ImshowAxesVisible','on');
    hold on;
    plot(D_i.Fecha_Hora,D_i.Pac_Ssh,'Color','b');
    plot(D_i.Fecha_Hora,D_i.Elec_dem_Ssh,'Color','r');
%     plot(Diff_i.Fecha_Hora,Diff_i.DiffConsGen_Ssh_1)
    title(strcat({'Power generation and demand in'},{' '},month(t,'name'),{' '}, string(year(t)),', Sun shield'));
    ylabel({'\color{blue}Power produced [kWh]';'\color{red}Energy demand [kWh]'});
    xtickformat('d');
    xticks(D_i.Fecha_Hora(12):2:D_i.Fecha_Hora(end));
    name=strcat('/Figuras/GenDem_Ssh/',string(month(t)),'_GenDem_Ssh_',string(month(t,'name')),'.eps');
    saveas(gcf, [pwd, char(name)],'epsc');  % here you save the figure
    hold off
    %Cwall
    figure2 = figure;
    iptsetpref('ImshowAxesVisible','on');
    hold on;
    plot(D_i.Fecha_Hora,D_i.Pac_Cwall,'Color','b');
    plot(D_i.Fecha_Hora,D_i.Elec_dem_Cwall,'Color','r');
%     plot(Diff2_i.Fecha_Hora,Diff2_i.DiffConsGen_Cwall_1)
    title(strcat({'Power generation and demand in'},{' '},month(t,'name'),{' '}, string(year(t)),', Curtain wall'));
    ylabel({'\color{blue}Power produced [kWh]';'\color{red}Energy demand [kWh]'});
    xtickformat('d');
    xticks(D_i.Fecha_Hora(12):2:D_i.Fecha_Hora(end));
    name=strcat('/Figuras/GenDem_Cwall/',string(month(t)),'_GenDem_Cwall_',string(month(t,'name')),'.eps');
    saveas(gcf,[pwd, char(name)],'epsc');  % here you save the figure
    hold off
    close all;
end

%% Sensitivity Tornado
names = {'Yearly cleaning';'Cleaning costs';'Injection rate';
    '\eta_{module} Sun shield / roof';'Radiation';'Curtain wall modules cost';
    'Mounting costs'; 'Installation costs'};
Van_Ssh_base = 568528.49;
Van_Cwall_base = -1733576.42;
VAN_Ssh_high = [1087754.45,  1152657.7, 572879.75, 790442.44, 862174.64,...
 568528.49, 576565.4, 583454.19];
VAN_Cwall_high = [ -570402.45, -425005.70, -1693893.11, -1634573.38,...
  -1317910.61, -1227164.77, -1578876.3, -1599099.98];
VAN_Cwall_cheapPanels = [Van_Cwall_base,Van_Cwall_base,Van_Cwall_base,...
    Van_Cwall_base,Van_Cwall_base, 38864.37,Van_Cwall_base,Van_Cwall_base];
VAN_Ssh_low = [ -210310.46,  -15600.72, 564177.22, 440363.72, 260398.90,...
 568528.49, 560491.6, 553602.79];
VAN_Cwall_low = [ -3478337.39, -3042147.14, -1773259.73, -1795792.53,...
 -2203528.10, -2239988.08, -1888276.6, -1868052.86];

%Sort based on lower for Cwall
[VAN_Cwall_low, ind]=sort(VAN_Cwall_low,'descend');
VAN_Cwall_high=VAN_Cwall_high(ind);
VAN_Ssh_low=VAN_Ssh_low(ind);
VAN_Ssh_high=VAN_Ssh_high(ind);
names_var=names(ind);

%Ssh
figure
h = barh(VAN_Ssh_high,'FaceColor',[0, 0.4470, 0.7410]);
hold on
barh(VAN_Ssh_low,'r')
bh = get(h,'BaseLine');
set(bh,'BaseValue',Van_Ssh_base);
yL = get(gca,'YLim');
plot([0 0], yL)
title('Sensitivity Sun shield')
set(gca,'yticklabel',names)
set(gca,'Ytick',1:length(names),'YTickLabel',1:length(names))
set(gca,'yticklabel',names_var)
xlabel('NPV [USD]')
labels_high = {'1 time','-75%','50%','21%','20%','-20%','-20%','-20%'};
labels_high = labels_high(ind);
labels_low = {'6 times','75%','-50%','-11%','-20%','20%','20%','20%'};
labels_low = labels_low(ind);
yt = get(gca, 'YTick');
text([VAN_Ssh_high(1:7)+4e4 VAN_Ssh_high(8)-2e5], yt, labels_high)
text([VAN_Ssh_low(1:7)-1.6e5 VAN_Ssh_low(8)+3e4], yt, labels_low)
name=strcat('/Figuras/Tornado_Ssh.eps');
saveas(gcf,[pwd, char(name)],'epsc');  % here you save the figure

%Cwall
figure
barh(VAN_Cwall_cheapPanels,'FaceColor',[0.4660, 0.6740, 0.1880])
hold on
h = barh(VAN_Cwall_high,'FaceColor',[0, 0.4470, 0.7410]);
barh(VAN_Cwall_low,'r')
bh = get(h,'BaseLine');
set(bh,'BaseValue',Van_Cwall_base);
yL = get(gca,'YLim');
plot([0 0], yL)
title('Sensitivity Curtain wall')
set(gca,'yticklabel',names)
set(gca,'Ytick',1:length(names),'YTickLabel',1:length(names))
set(gca,'yticklabel',names_var)
xlabel('NPV [USD]')
labels_high = {'1 time','-75%','50%','21%','20%','-20%','-20%','-20%'};
labels_high = labels_high(ind);
labels_low = {'6 times','75%','-50%','-11%','-20%','20%','20%','20%'};
labels_low = labels_low(ind);
labels_cheap = {'','','','','','-70%','',''};
labels_cheap = labels_cheap(ind);
yt = get(gca, 'YTick');
text(VAN_Cwall_high+5e4, yt, labels_high)
text([VAN_Cwall_low(1:7)-3.5e5 VAN_Cwall_low(8)+1e5], yt, labels_low)
text(VAN_Cwall_cheapPanels+5e4,yt,labels_cheap)

name=strcat('/Figuras/Tornado_Cwall.eps');
saveas(gcf,[pwd, char(name)],'epsc');  % here you save the figure
hold off
