import logging
import sys


def setup_logging(name: str = "shm") -> logging.Logger:
    logger = logging.getLogger(name)
    logger.setLevel(logging.INFO)
    handler = logging.StreamHandler(sys.stdout)
    fmt = logging.Formatter('%(asctime)s | %(levelname)s | %(name)s | %(message)s')
    handler.setFormatter(fmt)
    if not logger.handlers:
        logger.addHandler(handler)
    return logger
