from typing import Optional

from fastapi import APIRouter, Depends
from sqlalchemy.orm import Session

from .. import crud, schemas
from ..database import get_db

router = APIRouter(prefix="/sensors", tags=["sensors"])


@router.post("/", response_model=schemas.SensorRead)
def create_sensor(payload: schemas.SensorCreate, db: Session = Depends(get_db)):
    return crud.create_sensor(db, payload)


@router.post("/upsert", response_model=schemas.SensorRead)
def upsert_sensor(payload: schemas.SensorCreate, db: Session = Depends(get_db)):
    return crud.upsert_sensor(db, payload)


@router.get("/", response_model=list[schemas.SensorRead])
def list_sensors(structure_id: Optional[int] = None, db: Session = Depends(get_db)):
    return crud.list_sensors(db, structure_id=structure_id)
