import os, time

def file_size_mb(path: str) -> float:
    return os.path.getsize(path) / (1024*1024)

def is_file_stable(path: str, stable_seconds: int, min_mb: int) -> bool:
    if not os.path.exists(path):
        return False
    if file_size_mb(path) < min_mb:
        return False
    size1 = os.path.getsize(path)
    time.sleep(stable_seconds)
    if not os.path.exists(path):
        return False
    size2 = os.path.getsize(path)
    return size1 == size2
