from __future__ import annotations

from datetime import datetime
from typing import Dict, Any, List, Optional

from fastapi import FastAPI, HTTPException
from pydantic import BaseModel

from shm_shared.logging import setup_logging

from .pipeline import get_cleaning_params, clean_upload_influx

logger = setup_logging("cleaning.api")

app = FastAPI(title="SHM Cleaning Service")


@app.get("/healthz")
def health():
    return {"status": "ok"}


@app.get("/params")
def get_params():
    p = get_cleaning_params()
    return {
        "hp": p.hp,
        "lp": p.lp,
        "downsample": p.downsample,
        "filter_order": p.filter_order,
        "detrend_order": p.detrend_order,
    }




@app.post("/clean/upload/{upload_id}")
def clean_upload(upload_id: int) -> Dict[str, Any]:
    try:
        return clean_upload_influx(upload_id)
    except HTTPException:
        raise
    except Exception as e:
        raise HTTPException(status_code=500, detail=f"Cleaning failed: {e}")
